/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.util.Enumeration;

public class ProtectionDomain {
    private CodeSource code_source;
    private PermissionCollection perms;
    private ClassLoader classloader;
    private Principal[] principals;
    private boolean staticBinding;
    private boolean hasAllPermissions;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this(codeSource, permissionCollection, null, null, true);
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this(codeSource, permissionCollection, classLoader, principalArray, false);
    }

    private ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray, boolean bl) {
        this.code_source = codeSource;
        if (permissionCollection != null) {
            this.perms = permissionCollection;
            this.perms.setReadOnly();
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                if (!(enumeration.nextElement() instanceof AllPermission)) continue;
                this.hasAllPermissions = true;
            }
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticBinding = bl;
    }

    public final CodeSource getCodeSource() {
        return this.code_source;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.perms;
    }

    public boolean implies(Permission permission) {
        if (this.hasAllPermissions) {
            return true;
        }
        if (this.staticBinding) {
            return this.perms == null ? false : this.perms.implies(permission);
        }
        return Policy.getCurrentPolicy().implies(this, permission);
    }

    public String toString() {
        String string = SystemProperties.getProperty("line.separator");
        CPStringBuilder cPStringBuilder = new CPStringBuilder("ProtectionDomain (").append(string);
        if (this.code_source == null) {
            cPStringBuilder.append("CodeSource:null");
        } else {
            cPStringBuilder.append(this.code_source);
        }
        cPStringBuilder.append(string);
        if (this.classloader == null) {
            cPStringBuilder.append("ClassLoader:null");
        } else {
            cPStringBuilder.append(this.classloader);
        }
        cPStringBuilder.append(string);
        cPStringBuilder.append("Principals:");
        if (this.principals != null && this.principals.length > 0) {
            cPStringBuilder.append("[");
            for (int i = 0; i < this.principals.length; ++i) {
                Principal principal = this.principals[i];
                cPStringBuilder.append("'").append(principal.getName()).append("' of type ").append(principal.getClass().getName());
                if (i >= this.principals.length - 1) continue;
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append("]");
        } else {
            cPStringBuilder.append("none");
        }
        cPStringBuilder.append(string);
        if (!this.staticBinding) {
            if (Policy.isLoaded()) {
                try {
                    cPStringBuilder.append(Policy.getPolicy().getPermissions(this));
                }
                catch (SecurityException securityException) {
                    cPStringBuilder.append(this.perms);
                }
            } else {
                cPStringBuilder.append(this.perms);
            }
        } else {
            cPStringBuilder.append(this.perms);
        }
        return cPStringBuilder.append(string).append(")").append(string).toString();
    }
}

