/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Permissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 4858622370623524688L;
    private PermissionCollection allPermission;
    final Hashtable perms = new Hashtable();

    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("PermissionCollection is read only");
        }
        if (permission instanceof AllPermission) {
            if (this.allPermission == null) {
                this.allPermission = permission.newPermissionCollection();
                this.allPermission.add(permission);
                this.perms.put(permission.getClass(), this.allPermission);
            }
        } else {
            PermissionCollection permissionCollection = (PermissionCollection)this.perms.get(permission.getClass());
            if (permissionCollection == null) {
                permissionCollection = permission.newPermissionCollection();
                if (permissionCollection == null) {
                    permissionCollection = new PermissionsHash();
                }
                this.perms.put(permission.getClass(), permissionCollection);
            }
            permissionCollection.add(permission);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.allPermission != null) {
            return true;
        }
        PermissionCollection permissionCollection = (PermissionCollection)this.perms.get(permission.getClass());
        return permissionCollection == null ? false : permissionCollection.implies(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        return new Enumeration(){
            Enumeration main_enum;
            Enumeration sub_enum;
            {
                this.main_enum = Permissions.this.perms.elements();
            }

            public boolean hasMoreElements() {
                if (this.sub_enum == null) {
                    if (this.main_enum == null) {
                        return false;
                    }
                    if (!this.main_enum.hasMoreElements()) {
                        this.main_enum = null;
                        return false;
                    }
                    PermissionCollection permissionCollection = (PermissionCollection)this.main_enum.nextElement();
                    this.sub_enum = permissionCollection.elements();
                }
                if (!this.sub_enum.hasMoreElements()) {
                    this.sub_enum = null;
                    return this.hasMoreElements();
                }
                return true;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.sub_enum.nextElement();
            }
        };
    }

    private static final class PermissionsHash
    extends PermissionCollection {
        private static final long serialVersionUID = -8491988220802933440L;
        private final Hashtable perms = new Hashtable();

        private PermissionsHash() {
        }

        public void add(Permission permission) {
            this.perms.put(permission, permission);
        }

        public boolean implies(Permission permission) {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission2 = (Permission)enumeration.nextElement();
                if (!permission2.implies(permission)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return this.perms.elements();
        }
    }
}

