/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFactory {
    private static final String KEY_FACTORY = "KeyFactory";
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.keyFacSpi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return KeyFactory.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return KeyFactory.getInstance(string, provider);
    }

    public static KeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        CPStringBuilder cPStringBuilder = new CPStringBuilder("KeyFactory for algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(KEY_FACTORY, string, provider);
            return new KeyFactory((KeyFactorySpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final <T extends KeySpec> T getKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, clazz);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(key);
    }
}

