/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public class AlgorithmParameterGenerator {
    private static final String ALGORITHM_PARAMETER_GENERATOR = "AlgorithmParameterGenerator";
    private AlgorithmParameterGeneratorSpi paramGenSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi, Provider provider, String string) {
        this.paramGenSpi = algorithmParameterGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameterGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return AlgorithmParameterGenerator.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static AlgorithmParameterGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return AlgorithmParameterGenerator.getInstance(string, provider);
    }

    public static AlgorithmParameterGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        CPStringBuilder cPStringBuilder = new CPStringBuilder().append("AlgorithmParameterGenerator for algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(ALGORITHM_PARAMETER_GENERATOR, string, provider);
            return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n) {
        this.init(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.paramGenSpi.engineInit(n, secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.init(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.paramGenSpi.engineInit(algorithmParameterSpec, secureRandom);
    }

    public final AlgorithmParameters generateParameters() {
        return this.paramGenSpi.engineGenerateParameters();
    }
}

