/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.HashSet;

public final class AccessControlContext {
    private final ProtectionDomain[] protectionDomains;
    private final DomainCombiner combiner;

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        HashSet<ProtectionDomain> hashSet = new HashSet<ProtectionDomain>(protectionDomainArray.length);
        for (int i = 0; i < protectionDomainArray.length; ++i) {
            hashSet.add(protectionDomainArray[i]);
        }
        this.protectionDomains = hashSet.toArray(new ProtectionDomain[hashSet.size()]);
        this.combiner = null;
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        AccessControlContext accessControlContext2 = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            SecurityPermission securityPermission = new SecurityPermission("createAccessControlContext");
            if (securityManager.getClass() == SecurityManager.class) {
                accessControlContext2 = AccessController.getContext();
                accessControlContext2.checkPermission(securityPermission);
            } else {
                securityManager.checkPermission(securityPermission);
            }
        }
        if (accessControlContext2 == null) {
            accessControlContext2 = AccessController.getContext();
        }
        this.protectionDomains = domainCombiner.combine(accessControlContext2.protectionDomains, accessControlContext.protectionDomains);
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        this.protectionDomains = domainCombiner.combine(protectionDomainArray, accessControlContext.protectionDomains);
        this.combiner = domainCombiner;
    }

    public DomainCombiner getDomainCombiner() {
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        if (this.protectionDomains.length == 0) {
            throw new AccessControlException("permission " + permission + " not granted: no protection domains");
        }
        for (int i = 0; i < this.protectionDomains.length; ++i) {
            ProtectionDomain protectionDomain = this.protectionDomains[i];
            if (protectionDomain.implies(permission)) continue;
            throw new AccessControlException("permission " + permission + " not granted: " + protectionDomain + " does not imply it.");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AccessControlContext) {
            AccessControlContext accessControlContext = (AccessControlContext)object;
            if (accessControlContext.protectionDomains.length != this.protectionDomains.length) {
                return false;
            }
            for (int i = 0; i < this.protectionDomains.length; ++i) {
                int n;
                for (n = 0; n < accessControlContext.protectionDomains.length && !accessControlContext.protectionDomains[n].equals(this.protectionDomains[i]); ++n) {
                }
                if (n != accessControlContext.protectionDomains.length) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.protectionDomains.length; ++i) {
            n ^= this.protectionDomains[i].hashCode();
        }
        return n;
    }

    ProtectionDomain[] getProtectionDomains() {
        return this.protectionDomains;
    }
}

