/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.activation.DefaultActivationGroup;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.Adler32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivationGroupDesc
implements Serializable {
    static final long serialVersionUID = -4936225423168276595L;
    final String className;
    final String location;
    final MarshalledObject<?> data;
    final CommandEnvironment env;
    final Properties props;
    transient long hash;

    public ActivationGroupDesc(Properties properties, CommandEnvironment commandEnvironment) {
        this(DefaultActivationGroup.class.getName(), null, null, properties, commandEnvironment);
    }

    public ActivationGroupDesc(String string, String string2, MarshalledObject<?> marshalledObject, Properties properties, CommandEnvironment commandEnvironment) {
        this.className = string;
        this.location = string2;
        this.data = marshalledObject;
        this.props = properties;
        this.env = commandEnvironment;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject<?> getData() {
        return this.data;
    }

    public Properties getPropertyOverrides() {
        return this.props;
    }

    public CommandEnvironment getCommandEnvironment() {
        return this.env;
    }

    public boolean equals(Object object) {
        if (object instanceof ActivationGroupDesc) {
            ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)object;
            if (this.hash == 0L) {
                this.hashCode();
            }
            if (activationGroupDesc.hash == 0L) {
                activationGroupDesc.hashCode();
            }
            if (this.hash != activationGroupDesc.hash) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.className, activationGroupDesc.className)) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.data, activationGroupDesc.data)) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.env, activationGroupDesc.env)) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.location, activationGroupDesc.location)) {
                return false;
            }
            if (ActivationGroupDesc.eq(this.props, activationGroupDesc.props)) {
                return true;
            }
            if (this.props.size() != activationGroupDesc.props.size()) {
                return false;
            }
            Enumeration<?> enumeration = this.props.propertyNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (!activationGroupDesc.props.containsKey(obj)) {
                    return false;
                }
                if (ActivationGroupDesc.eq(this.props.get(obj), activationGroupDesc.props.get(obj))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean eq(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        return object.equals(object2);
    }

    public int hashCode() {
        if (this.hash == 0L) {
            Adler32 adler32 = new Adler32();
            if (this.className != null) {
                adler32.update(this.className.getBytes());
            }
            if (this.data != null) {
                adler32.update(this.data.hashCode());
            }
            if (this.env != null) {
                adler32.update(this.env.hashCode());
            }
            if (this.location != null) {
                adler32.update(this.location.getBytes());
            }
            if (this.props != null) {
                Enumeration<?> enumeration = this.props.propertyNames();
                TreeSet treeSet = new TreeSet();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    if (object == null) continue;
                    treeSet.add(object);
                }
                for (Object object : treeSet) {
                    Object v = this.props.get(object);
                    adler32.update(object.hashCode());
                    if (v == null) continue;
                    adler32.update(v.hashCode());
                }
            }
            this.hash = adler32.getValue();
        }
        return (int)this.hash;
    }

    public static class CommandEnvironment
    implements Serializable {
        static final long serialVersionUID = 6165754737887770191L;
        private static final String[] NO_ARGS = new String[0];
        final String command;
        final String[] options;

        public CommandEnvironment(String string, String[] stringArray) {
            this.command = string;
            this.options = stringArray != null ? stringArray : NO_ARGS;
        }

        public String getCommandPath() {
            return this.command;
        }

        public String[] getCommandOptions() {
            return this.options;
        }

        public boolean equals(Object object) {
            if (object instanceof CommandEnvironment) {
                CommandEnvironment commandEnvironment = (CommandEnvironment)object;
                if (this.command == null || commandEnvironment.command == null ? this.command != commandEnvironment.command : !this.command.equals(commandEnvironment.command)) {
                    return false;
                }
                return Arrays.equals(this.options, commandEnvironment.options);
            }
            return false;
        }

        public int hashCode() {
            int n = this.command == null ? 0 : this.command.hashCode();
            for (int i = 0; i < this.options.length; ++i) {
                n ^= this.options[i].hashCode();
            }
            return n;
        }
    }
}

