/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.activation.DefaultActivationGroup;
import gnu.java.rmi.activation.DefaultActivationSystem;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.UnicastRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivationGroup
extends UnicastRemoteObject
implements ActivationInstantiator {
    static final long serialVersionUID = -7696947875314805420L;
    static ActivationGroupID currentGroupId = null;
    final ActivationGroupID groupId;
    ActivationMonitor monitor;
    long incarnation;
    static ActivationSystem system;
    static final Class[] cConstructorTypes;

    protected ActivationGroup(ActivationGroupID activationGroupID) throws RemoteException {
        this.groupId = activationGroupID;
    }

    public abstract void activeObject(ActivationID var1, Remote var2) throws ActivationException, UnknownObjectException, RemoteException;

    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        if (this.monitor != null) {
            this.monitor.inactiveObject(activationID);
        }
        return true;
    }

    public static ActivationGroup createGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, long l) throws ActivationException {
        Class clazz;
        Object object;
        if (system == null) {
            system = activationGroupID.system;
        }
        ActivationGroup activationGroup = null;
        if (activationGroupDesc.className != null) {
            try {
                object = Thread.currentThread().getContextClassLoader();
                clazz = ((ClassLoader)object).loadClass(activationGroupDesc.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ActivationException activationException = new ActivationException("Cannot load " + activationGroupDesc.className);
                activationException.detail = classNotFoundException;
                throw activationException;
            }
        } else {
            clazz = DefaultActivationGroup.class;
        }
        try {
            object = clazz.getConstructor(cConstructorTypes);
            activationGroup = (ActivationGroup)((Constructor)object).newInstance(activationGroupID, activationGroupDesc.data);
        }
        catch (Exception exception) {
            ActivationException activationException = new ActivationException("Cannot instantiate " + activationGroupDesc.className);
            activationException.detail = exception;
            throw activationException;
        }
        currentGroupId = activationGroupID;
        try {
            activationGroup.monitor = ActivationGroup.getSystem().activeGroup(activationGroupID, activationGroup, l);
            return activationGroup;
        }
        catch (RemoteException remoteException) {
            ActivationException activationException = new ActivationException("createGroup");
            activationException.detail = remoteException;
            throw activationException;
        }
    }

    public static ActivationGroupID currentGroupID() {
        try {
            if (currentGroupId == null) {
                ActivationGroup.setSystem(DefaultActivationSystem.get());
            }
        }
        catch (ActivationException activationException) {
            InternalError internalError = new InternalError("Unable to activate AS");
            internalError.initCause(activationException);
            throw internalError;
        }
        return currentGroupId;
    }

    public static void setSystem(ActivationSystem activationSystem) throws ActivationException {
        if (currentGroupId != null) {
            throw new ActivationException("Group active");
        }
        try {
            system = activationSystem;
            ActivationGroupDesc activationGroupDesc = new ActivationGroupDesc(DefaultActivationGroup.class.getName(), "", null, null, null);
            currentGroupId = system.registerGroup(activationGroupDesc);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to start default AG");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static ActivationSystem getSystem() throws ActivationException {
        if (system == null) {
            system = DefaultActivationSystem.get();
        }
        return system;
    }

    protected void activeObject(ActivationID activationID, MarshalledObject<? extends Remote> marshalledObject) throws ActivationException, UnknownObjectException, RemoteException {
        if (this.monitor != null) {
            this.monitor.activeObject(activationID, marshalledObject);
        }
        activationID.group = this;
    }

    protected void inactiveGroup() throws UnknownGroupException, RemoteException {
        if (this.monitor != null) {
            this.monitor.inactiveGroup(this.groupId, this.incarnation);
        }
        if (currentGroupId != null && currentGroupId.equals(this.groupId)) {
            currentGroupId = null;
        }
    }

    static {
        cConstructorTypes = new Class[]{ActivationGroupID.class, MarshalledObject.class};
    }
}

