/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private boolean blocking = true;
    private Object LOCK = new Object();
    private SelectorProvider provider;
    private LinkedList keys = new LinkedList();

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    public final Object blockingLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectableChannel configureBlocking(boolean bl) throws IOException {
        Object object = this.blockingLock();
        synchronized (object) {
            if (this.blocking != bl) {
                this.implConfigureBlocking(bl);
                this.blocking = bl;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void implCloseChannel() throws IOException {
        try {
            this.implCloseSelectableChannel();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext()) {
                ((SelectionKey)iterator.next()).cancel();
            }
            throw throwable;
        }
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            ((SelectionKey)iterator.next()).cancel();
        }
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final boolean isRegistered() {
        return !this.keys.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectionKey keyFor(Selector selector) {
        if (!this.isOpen()) {
            return null;
        }
        try {
            Object object = this.blockingLock();
            synchronized (object) {
                return this.locate(selector);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    private SelectionKey locate(Selector selector) {
        ListIterator listIterator = this.keys.listIterator();
        while (listIterator.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)listIterator.next();
            if (selectionKey.selector() != selector) continue;
            return selectionKey;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((n & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        SelectionKey selectionKey = null;
        AbstractSelector abstractSelector = (AbstractSelector)selector;
        Object object2 = this.blockingLock();
        synchronized (object2) {
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            selectionKey = this.locate(abstractSelector);
            if (selectionKey != null && selectionKey.isValid()) {
                selectionKey.interestOps(n);
                selectionKey.attach(object);
            } else {
                selectionKey = abstractSelector.register(this, n, object);
                if (selectionKey != null) {
                    this.addSelectionKey(selectionKey);
                }
            }
        }
        return selectionKey;
    }

    void addSelectionKey(SelectionKey selectionKey) {
        this.keys.add(selectionKey);
    }

    void removeSelectionKey(SelectionKey selectionKey) {
        this.keys.remove(selectionKey);
    }
}

