/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ShortBufferImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShortBuffer
extends Buffer
implements Comparable<ShortBuffer> {
    final int array_offset;
    final short[] backing_buffer;

    ShortBuffer(int n, int n2, int n3, int n4, Pointer pointer, short[] sArray, int n5) {
        super(n, n2, n3, n4, pointer);
        this.backing_buffer = sArray;
        this.array_offset = n5;
    }

    public static ShortBuffer allocate(int n) {
        return new ShortBufferImpl(n);
    }

    public static final ShortBuffer wrap(short[] sArray, int n, int n2) {
        return new ShortBufferImpl(sArray, 0, sArray.length, n + n2, n, -1, false);
    }

    public static final ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public ShortBuffer get(short[] sArray, int n, int n2) {
        ShortBuffer.checkArraySize(sArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            sArray[i] = this.get();
        }
        return this;
    }

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(shortBuffer.remaining());
        if (shortBuffer.remaining() > 0) {
            short[] sArray = new short[shortBuffer.remaining()];
            shortBuffer.get(sArray);
            this.put(sArray);
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n, int n2) {
        ShortBuffer.checkArraySize(sArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(sArray[i]);
        }
        return this;
    }

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final short[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    @Override
    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            n += (this.get(i) + 30) * (n2 *= 31);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ShortBuffer) {
            return this.compareTo((ShortBuffer)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(ShortBuffer shortBuffer) {
        int n = Math.min(this.remaining(), shortBuffer.remaining());
        int n2 = this.position();
        int n3 = shortBuffer.position();
        for (int i = 0; i < n; ++i) {
            short s;
            short s2;
            if ((s2 = this.get(n2++)) == (s = shortBuffer.get(n3++))) continue;
            if (s2 < s) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - shortBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer compact();

    @Override
    public abstract boolean isDirect();

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();
}

