/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.IntBuffer;

final class IntBufferImpl
extends IntBuffer {
    private final boolean readOnly;

    IntBufferImpl(int n) {
        this(new int[n], 0, n, n, 0, -1, false);
    }

    IntBufferImpl(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5, null, nArray, n);
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public IntBuffer slice() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public IntBuffer duplicate() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public IntBuffer asReadOnlyBuffer() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public IntBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        int n2 = this.limit() - n;
        if (n2 > 0) {
            System.arraycopy(this.backing_buffer, this.array_offset + n, this.backing_buffer, this.array_offset, n2);
        }
        this.position(n2);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public int get() {
        this.checkForUnderflow();
        int n = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return n;
    }

    public IntBuffer put(int n) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = n;
        this.position(this.position() + 1);
        return this;
    }

    public int get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public IntBuffer put(int n, int n2) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = n2;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

