/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.IntBufferImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntBuffer
extends Buffer
implements Comparable<IntBuffer> {
    final int array_offset;
    final int[] backing_buffer;

    IntBuffer(int n, int n2, int n3, int n4, Pointer pointer, int[] nArray, int n5) {
        super(n, n2, n3, n4, pointer);
        this.backing_buffer = nArray;
        this.array_offset = n5;
    }

    public static IntBuffer allocate(int n) {
        return new IntBufferImpl(n);
    }

    public static final IntBuffer wrap(int[] nArray, int n, int n2) {
        return new IntBufferImpl(nArray, 0, nArray.length, n + n2, n, -1, false);
    }

    public static final IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public IntBuffer get(int[] nArray, int n, int n2) {
        IntBuffer.checkArraySize(nArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            nArray[i] = this.get();
        }
        return this;
    }

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(intBuffer.remaining());
        if (intBuffer.remaining() > 0) {
            int[] nArray = new int[intBuffer.remaining()];
            intBuffer.get(nArray);
            this.put(nArray);
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        IntBuffer.checkArraySize(nArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(nArray[i]);
        }
        return this;
    }

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final int[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    @Override
    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            n += (this.get(i) + 30) * (n2 *= 31);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof IntBuffer) {
            return this.compareTo((IntBuffer)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(IntBuffer intBuffer) {
        int n = Math.min(this.remaining(), intBuffer.remaining());
        int n2 = this.position();
        int n3 = intBuffer.position();
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            if ((n5 = this.get(n2++)) == (n4 = intBuffer.get(n3++))) continue;
            if (n5 < n4) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - intBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    @Override
    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();
}

