/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.VMDirectByteBuffer;

final class FloatViewBufferImpl
extends FloatBuffer {
    private final int offset;
    private final ByteBuffer bb;
    private final boolean readOnly;
    private final ByteOrder endian;

    FloatViewBufferImpl(ByteBuffer byteBuffer, int n) {
        super(n, n, 0, -1, byteBuffer.isDirect() ? VMDirectByteBuffer.adjustAddress(byteBuffer.address, byteBuffer.position()) : null, null, 0);
        this.bb = byteBuffer;
        this.offset = byteBuffer.position();
        this.readOnly = byteBuffer.isReadOnly();
        this.endian = byteBuffer.order();
    }

    public FloatViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, ByteOrder byteOrder) {
        super(n2, n3, n4, n5, byteBuffer.isDirect() ? VMDirectByteBuffer.adjustAddress(byteBuffer.address, n) : null, null, 0);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteOrder;
    }

    public float get() {
        int n = this.position();
        float f = ByteBufferHelper.getFloat(this.bb, (n << 2) + this.offset, this.endian);
        this.position(n + 1);
        return f;
    }

    public float get(int n) {
        return ByteBufferHelper.getFloat(this.bb, (n << 2) + this.offset, this.endian);
    }

    public FloatBuffer put(float f) {
        int n = this.position();
        ByteBufferHelper.putFloat(this.bb, (n << 2) + this.offset, f, this.endian);
        this.position(n + 1);
        return this;
    }

    public FloatBuffer put(int n, float f) {
        ByteBufferHelper.putFloat(this.bb, (n << 2) + this.offset, f, this.endian);
        return this;
    }

    public FloatBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 4 * this.position(), 4 * n);
            this.position(n);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public FloatBuffer slice() {
        return new FloatViewBufferImpl(this.bb, (this.position() << 2) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    FloatBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        return new FloatViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), n, n2, bl, this.endian);
    }

    public FloatBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

