/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

final class DoubleBufferImpl
extends DoubleBuffer {
    private final boolean readOnly;

    DoubleBufferImpl(int n) {
        this(new double[n], 0, n, n, 0, -1, false);
    }

    DoubleBufferImpl(double[] dArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5, null, dArray, n);
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DoubleBuffer slice() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public DoubleBuffer duplicate() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public DoubleBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        int n2 = this.limit() - n;
        if (n2 > 0) {
            System.arraycopy(this.backing_buffer, this.array_offset + n, this.backing_buffer, this.array_offset, n2);
        }
        this.position(n2);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public double get() {
        this.checkForUnderflow();
        double d = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return d;
    }

    public DoubleBuffer put(double d) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = d;
        this.position(this.position() + 1);
        return this;
    }

    public double get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public DoubleBuffer put(int n, double d) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = d;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

