/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;
import java.nio.VMDirectByteBuffer;

abstract class DirectByteBufferImpl
extends ByteBuffer {
    private final Object owner;

    DirectByteBufferImpl(int n) {
        super(n, n, 0, -1, VMDirectByteBuffer.allocate(n), null, 0);
        this.owner = this;
    }

    DirectByteBufferImpl(Pointer pointer, int n) {
        super(n, n, 0, -1, pointer, null, 0);
        this.owner = null;
    }

    DirectByteBufferImpl(Object object, Pointer pointer, int n, int n2, int n3) {
        super(n, n2, n3, -1, pointer, null, 0);
        this.owner = object;
    }

    public static ByteBuffer allocate(int n) {
        return new ReadWrite(n);
    }

    protected void finalize() throws Throwable {
        if (this.owner == this) {
            VMDirectByteBuffer.free(this.address);
        }
    }

    public byte get() {
        this.checkForUnderflow();
        int n = this.position();
        byte by = VMDirectByteBuffer.get(this.address, n);
        this.position(n + 1);
        return by;
    }

    public byte get(int n) {
        this.checkIndex(n);
        return VMDirectByteBuffer.get(this.address, n);
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        DirectByteBufferImpl.checkArraySize(byArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = this.position();
        VMDirectByteBuffer.get(this.address, n3, byArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    public ByteBuffer put(byte by) {
        this.checkForOverflow();
        int n = this.position();
        VMDirectByteBuffer.put(this.address, n, by);
        this.position(n + 1);
        return this;
    }

    public ByteBuffer put(int n, byte by) {
        this.checkIndex(n);
        VMDirectByteBuffer.put(this.address, n, by);
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        DirectByteBufferImpl.checkArraySize(byArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = this.position();
        VMDirectByteBuffer.put(this.address, n3, byArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    void shiftDown(int n, int n2, int n3) {
        VMDirectByteBuffer.shiftDown(this.address, n, n2, n3);
    }

    public ByteBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        if (n > 0) {
            int n2 = this.remaining();
            VMDirectByteBuffer.shiftDown(this.address, 0, n, n2);
            this.position(n2);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public ByteBuffer slice() {
        int n = this.remaining();
        if (this.isReadOnly()) {
            return new ReadOnly(this.owner, VMDirectByteBuffer.adjustAddress(this.address, this.position()), n, n, 0);
        }
        return new ReadWrite(this.owner, VMDirectByteBuffer.adjustAddress(this.address, this.position()), n, n, 0);
    }

    private ByteBuffer duplicate(boolean bl) {
        int n = this.position();
        if (this.mark != -1) {
            this.reset();
        }
        int n2 = this.position();
        this.position(n);
        DirectByteBufferImpl directByteBufferImpl = bl ? new ReadOnly(this.owner, this.address, this.capacity(), this.limit(), n) : new ReadWrite(this.owner, this.address, this.capacity(), this.limit(), n);
        if (n2 != n) {
            directByteBufferImpl.position(n2);
            directByteBufferImpl.mark();
            directByteBufferImpl.position(n);
        }
        return directByteBufferImpl;
    }

    public ByteBuffer duplicate() {
        return this.duplicate(this.isReadOnly());
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isDirect() {
        return true;
    }

    public CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.remaining() >> 1);
    }

    public ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.remaining() >> 1);
    }

    public IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.remaining() >> 2);
    }

    public LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.remaining() >> 3);
    }

    public FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.remaining() >> 2);
    }

    public DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.remaining() >> 3);
    }

    public char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public ByteBuffer putChar(char c) {
        ByteBufferHelper.putChar(this, c, this.order());
        return this;
    }

    public char getChar(int n) {
        return ByteBufferHelper.getChar(this, n, this.order());
    }

    public ByteBuffer putChar(int n, char c) {
        ByteBufferHelper.putChar(this, n, c, this.order());
        return this;
    }

    public short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public ByteBuffer putShort(short s) {
        ByteBufferHelper.putShort(this, s, this.order());
        return this;
    }

    public short getShort(int n) {
        return ByteBufferHelper.getShort(this, n, this.order());
    }

    public ByteBuffer putShort(int n, short s) {
        ByteBufferHelper.putShort(this, n, s, this.order());
        return this;
    }

    public int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public ByteBuffer putInt(int n) {
        ByteBufferHelper.putInt(this, n, this.order());
        return this;
    }

    public int getInt(int n) {
        return ByteBufferHelper.getInt(this, n, this.order());
    }

    public ByteBuffer putInt(int n, int n2) {
        ByteBufferHelper.putInt(this, n, n2, this.order());
        return this;
    }

    public long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public ByteBuffer putLong(long l) {
        ByteBufferHelper.putLong(this, l, this.order());
        return this;
    }

    public long getLong(int n) {
        return ByteBufferHelper.getLong(this, n, this.order());
    }

    public ByteBuffer putLong(int n, long l) {
        ByteBufferHelper.putLong(this, n, l, this.order());
        return this;
    }

    public float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public ByteBuffer putFloat(float f) {
        ByteBufferHelper.putFloat(this, f, this.order());
        return this;
    }

    public float getFloat(int n) {
        return ByteBufferHelper.getFloat(this, n, this.order());
    }

    public ByteBuffer putFloat(int n, float f) {
        ByteBufferHelper.putFloat(this, n, f, this.order());
        return this;
    }

    public double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public ByteBuffer putDouble(double d) {
        ByteBufferHelper.putDouble(this, d, this.order());
        return this;
    }

    public double getDouble(int n) {
        return ByteBufferHelper.getDouble(this, n, this.order());
    }

    public ByteBuffer putDouble(int n, double d) {
        ByteBufferHelper.putDouble(this, n, d, this.order());
        return this;
    }

    static final class ReadWrite
    extends DirectByteBufferImpl {
        ReadWrite(int n) {
            super(n);
        }

        ReadWrite(Pointer pointer, int n) {
            super(pointer, n);
        }

        ReadWrite(Object object, Pointer pointer, int n, int n2, int n3) {
            super(object, pointer, n, n2, n3);
        }

        public boolean isReadOnly() {
            return false;
        }
    }

    static final class ReadOnly
    extends DirectByteBufferImpl {
        ReadOnly(Object object, Pointer pointer, int n, int n2, int n3) {
            super(object, pointer, n, n2, n3);
        }

        public ByteBuffer put(byte by) {
            throw new ReadOnlyBufferException();
        }

        public ByteBuffer put(int n, byte by) {
            throw new ReadOnlyBufferException();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

