/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBufferImpl;
import java.nio.CharSequenceBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
CharSequence,
Readable,
Appendable {
    final int array_offset;
    final char[] backing_buffer;

    CharBuffer(int n, int n2, int n3, int n4, Pointer pointer, char[] cArray, int n5) {
        super(n, n2, n3, n4, pointer);
        this.backing_buffer = cArray;
        this.array_offset = n5;
    }

    public static CharBuffer allocate(int n) {
        return new CharBufferImpl(n);
    }

    public static final CharBuffer wrap(char[] cArray, int n, int n2) {
        return new CharBufferImpl(cArray, 0, cArray.length, n + n2, n, -1, false);
    }

    public static final CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public static final CharBuffer wrap(CharSequence charSequence, int n, int n2) {
        return new CharSequenceBuffer(charSequence, n, n2);
    }

    public static final CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        CharBuffer.checkArraySize(cArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            cArray[i] = this.get();
        }
        return this;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        int n = Math.min(charBuffer.remaining(), this.remaining());
        char[] cArray = new char[n];
        this.get(cArray);
        charBuffer.put(cArray);
        return n;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(charBuffer.remaining());
        if (charBuffer.remaining() > 0) {
            char[] cArray = new char[charBuffer.remaining()];
            charBuffer.get(cArray);
            this.put(cArray);
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        CharBuffer.checkArraySize(cArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(cArray[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    @Override
    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            n += (this.get(i) + 30) * (n2 *= 31);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CharBuffer) {
            return this.compareTo((CharBuffer)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(CharBuffer charBuffer) {
        int n = Math.min(this.remaining(), charBuffer.remaining());
        int n2 = this.position();
        int n3 = charBuffer.position();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2;
            if ((c2 = this.get(n2++)) == (c = charBuffer.get(n3++))) continue;
            if (c2 < c) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - charBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    @Override
    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    @Override
    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        char[] cArray = new char[this.length()];
        int n = this.position();
        this.get(cArray, 0, cArray.length);
        this.position(n);
        return new String(cArray);
    }

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String string, int n, int n2) {
        return this.put(string.toCharArray(), n, n2);
    }

    public final CharBuffer put(String string) {
        return this.put(string.toCharArray(), 0, string.length());
    }

    @Override
    public final char charAt(int n) {
        if (n < 0 || n >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + n);
    }

    @Override
    public CharBuffer append(char c) {
        this.put(c);
        return this;
    }

    @Override
    public CharBuffer append(CharSequence charSequence) {
        this.put(charSequence == null ? "null" : charSequence.toString());
        return this;
    }

    @Override
    public CharBuffer append(CharSequence charSequence, int n, int n2) {
        this.put(charSequence == null ? "null" : charSequence.subSequence(n, n2).toString());
        return this;
    }
}

