/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class ByteBufferHelper {
    ByteBufferHelper() {
    }

    public static char getChar(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        return (char)ByteBufferHelper.getShort(byteBuffer, byteOrder);
    }

    public static void putChar(ByteBuffer byteBuffer, char c, ByteOrder byteOrder) {
        ByteBufferHelper.putShort(byteBuffer, (short)c, byteOrder);
    }

    public static char getChar(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        return (char)ByteBufferHelper.getShort(byteBuffer, n, byteOrder);
    }

    public static void putChar(ByteBuffer byteBuffer, int n, char c, ByteOrder byteOrder) {
        ByteBufferHelper.putShort(byteBuffer, n, (short)c, byteOrder);
    }

    public static short getShort(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        byteBuffer.checkForUnderflow(2);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (short)((byteBuffer.get() & 0xFF) + (byteBuffer.get() << 8));
        }
        return (short)((byteBuffer.get() << 8) + (byteBuffer.get() & 0xFF));
    }

    public static void putShort(ByteBuffer byteBuffer, short s, ByteOrder byteOrder) {
        byteBuffer.checkForOverflow(2);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put((byte)s);
            byteBuffer.put((byte)(s >> 8));
        } else {
            byteBuffer.put((byte)(s >> 8));
            byteBuffer.put((byte)s);
        }
    }

    public static short getShort(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (short)((byteBuffer.get(n) & 0xFF) + (byteBuffer.get(++n) << 8));
        }
        return (short)((byteBuffer.get(n) << 8) + (byteBuffer.get(++n) & 0xFF));
    }

    public static void putShort(ByteBuffer byteBuffer, int n, short s, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put(n, (byte)s);
            byteBuffer.put(++n, (byte)(s >> 8));
        } else {
            byteBuffer.put(n, (byte)(s >> 8));
            byteBuffer.put(++n, (byte)s);
        }
    }

    public static int getInt(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        byteBuffer.checkForUnderflow(4);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (byteBuffer.get() & 0xFF) + ((byteBuffer.get() & 0xFF) << 8) + ((byteBuffer.get() & 0xFF) << 16) + (byteBuffer.get() << 24);
        }
        return (byteBuffer.get() << 24) + ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
    }

    public static void putInt(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        byteBuffer.checkForOverflow(4);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put((byte)n);
            byteBuffer.put((byte)(n >> 8));
            byteBuffer.put((byte)(n >> 16));
            byteBuffer.put((byte)(n >> 24));
        } else {
            byteBuffer.put((byte)(n >> 24));
            byteBuffer.put((byte)(n >> 16));
            byteBuffer.put((byte)(n >> 8));
            byteBuffer.put((byte)n);
        }
    }

    public static int getInt(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (byteBuffer.get(n) & 0xFF) + ((byteBuffer.get(++n) & 0xFF) << 8) + ((byteBuffer.get(++n) & 0xFF) << 16) + (byteBuffer.get(++n) << 24);
        }
        return (byteBuffer.get(n) << 24) + ((byteBuffer.get(++n) & 0xFF) << 16) + ((byteBuffer.get(++n) & 0xFF) << 8) + (byteBuffer.get(++n) & 0xFF);
    }

    public static void putInt(ByteBuffer byteBuffer, int n, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put(n, (byte)n2);
            byteBuffer.put(++n, (byte)(n2 >> 8));
            byteBuffer.put(++n, (byte)(n2 >> 16));
            byteBuffer.put(++n, (byte)(n2 >> 24));
        } else {
            byteBuffer.put(n, (byte)(n2 >> 24));
            byteBuffer.put(++n, (byte)(n2 >> 16));
            byteBuffer.put(++n, (byte)(n2 >> 8));
            byteBuffer.put(++n, (byte)n2);
        }
    }

    public static long getLong(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        byteBuffer.checkForUnderflow(8);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (long)((byteBuffer.get() & 0xFF) + ((byteBuffer.get() & 0xFF) << 8) + ((byteBuffer.get() & 0xFF) << 16)) + (((long)byteBuffer.get() & 0xFFL) << 24) + (((long)byteBuffer.get() & 0xFFL) << 32) + (((long)byteBuffer.get() & 0xFFL) << 40) + (((long)byteBuffer.get() & 0xFFL) << 48) + ((long)byteBuffer.get() << 56);
        }
        return ((long)byteBuffer.get() << 56) + (((long)byteBuffer.get() & 0xFFL) << 48) + (((long)byteBuffer.get() & 0xFFL) << 40) + (((long)byteBuffer.get() & 0xFFL) << 32) + (((long)byteBuffer.get() & 0xFFL) << 24) + (long)((byteBuffer.get() & 0xFF) << 16) + (long)((byteBuffer.get() & 0xFF) << 8) + (long)(byteBuffer.get() & 0xFF);
    }

    public static void putLong(ByteBuffer byteBuffer, long l, ByteOrder byteOrder) {
        byteBuffer.checkForOverflow(8);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put((byte)l);
            byteBuffer.put((byte)(l >> 8));
            byteBuffer.put((byte)(l >> 16));
            byteBuffer.put((byte)(l >> 24));
            byteBuffer.put((byte)(l >> 32));
            byteBuffer.put((byte)(l >> 40));
            byteBuffer.put((byte)(l >> 48));
            byteBuffer.put((byte)(l >> 56));
        } else {
            byteBuffer.put((byte)(l >> 56));
            byteBuffer.put((byte)(l >> 48));
            byteBuffer.put((byte)(l >> 40));
            byteBuffer.put((byte)(l >> 32));
            byteBuffer.put((byte)(l >> 24));
            byteBuffer.put((byte)(l >> 16));
            byteBuffer.put((byte)(l >> 8));
            byteBuffer.put((byte)l);
        }
    }

    public static long getLong(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (long)((byteBuffer.get(n) & 0xFF) + ((byteBuffer.get(++n) & 0xFF) << 8) + ((byteBuffer.get(++n) & 0xFF) << 16)) + (((long)byteBuffer.get(++n) & 0xFFL) << 24) + (((long)byteBuffer.get(++n) & 0xFFL) << 32) + (((long)byteBuffer.get(++n) & 0xFFL) << 40) + (((long)byteBuffer.get(++n) & 0xFFL) << 48) + ((long)byteBuffer.get(++n) << 56);
        }
        return ((long)byteBuffer.get(n) << 56) + (((long)byteBuffer.get(++n) & 0xFFL) << 48) + (((long)byteBuffer.get(++n) & 0xFFL) << 40) + (((long)byteBuffer.get(++n) & 0xFFL) << 32) + (((long)byteBuffer.get(++n) & 0xFFL) << 24) + (long)((byteBuffer.get(++n) & 0xFF) << 16) + (long)((byteBuffer.get(++n) & 0xFF) << 8) + (long)(byteBuffer.get(++n) & 0xFF);
    }

    public static void putLong(ByteBuffer byteBuffer, int n, long l, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put(n, (byte)l);
            byteBuffer.put(++n, (byte)(l >> 8));
            byteBuffer.put(++n, (byte)(l >> 16));
            byteBuffer.put(++n, (byte)(l >> 24));
            byteBuffer.put(++n, (byte)(l >> 32));
            byteBuffer.put(++n, (byte)(l >> 40));
            byteBuffer.put(++n, (byte)(l >> 48));
            byteBuffer.put(++n, (byte)(l >> 56));
        } else {
            byteBuffer.put(n, (byte)(l >> 56));
            byteBuffer.put(++n, (byte)(l >> 48));
            byteBuffer.put(++n, (byte)(l >> 40));
            byteBuffer.put(++n, (byte)(l >> 32));
            byteBuffer.put(++n, (byte)(l >> 24));
            byteBuffer.put(++n, (byte)(l >> 16));
            byteBuffer.put(++n, (byte)(l >> 8));
            byteBuffer.put(++n, (byte)l);
        }
    }

    public static float getFloat(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        return Float.intBitsToFloat(ByteBufferHelper.getInt(byteBuffer, byteOrder));
    }

    public static void putFloat(ByteBuffer byteBuffer, float f, ByteOrder byteOrder) {
        ByteBufferHelper.putInt(byteBuffer, Float.floatToRawIntBits(f), byteOrder);
    }

    public static float getFloat(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        return Float.intBitsToFloat(ByteBufferHelper.getInt(byteBuffer, n, byteOrder));
    }

    public static void putFloat(ByteBuffer byteBuffer, int n, float f, ByteOrder byteOrder) {
        ByteBufferHelper.putInt(byteBuffer, n, Float.floatToRawIntBits(f), byteOrder);
    }

    public static double getDouble(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteBufferHelper.getLong(byteBuffer, byteOrder));
    }

    public static void putDouble(ByteBuffer byteBuffer, double d, ByteOrder byteOrder) {
        ByteBufferHelper.putLong(byteBuffer, Double.doubleToRawLongBits(d), byteOrder);
    }

    public static double getDouble(ByteBuffer byteBuffer, int n, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteBufferHelper.getLong(byteBuffer, n, byteOrder));
    }

    public static void putDouble(ByteBuffer byteBuffer, int n, double d, ByteOrder byteOrder) {
        ByteBufferHelper.putLong(byteBuffer, n, Double.doubleToRawLongBits(d), byteOrder);
    }
}

