/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.Pointer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;
import java.nio.ReadOnlyBufferException;

public abstract class Buffer {
    private final int cap;
    int limit;
    int pos;
    int mark;
    final Pointer address;

    Buffer(int n, int n2, int n3, int n4, Pointer pointer) {
        this.address = pointer;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.cap = n;
        this.limit(n2);
        this.position(n3);
        if (n4 >= 0) {
            if (n4 > this.pos) {
                throw new IllegalArgumentException();
            }
            this.mark = n4;
        } else {
            this.mark = -1;
        }
    }

    public final int capacity() {
        return this.cap;
    }

    public final Buffer clear() {
        this.limit = this.cap;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.pos;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public abstract boolean isReadOnly();

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int n) {
        if (n < 0 || n > this.cap) {
            throw new IllegalArgumentException();
        }
        if (n < this.mark) {
            this.mark = -1;
        }
        if (this.pos > n) {
            this.pos = n;
        }
        this.limit = n;
        return this;
    }

    public final Buffer mark() {
        this.mark = this.pos;
        return this;
    }

    public final int position() {
        return this.pos;
    }

    public final Buffer position(int n) {
        if (n < 0 || n > this.limit) {
            throw new IllegalArgumentException();
        }
        if (n <= this.mark) {
            this.mark = -1;
        }
        this.pos = n;
        return this;
    }

    public final int remaining() {
        return this.limit - this.pos;
    }

    public final Buffer reset() {
        if (this.mark == -1) {
            throw new InvalidMarkException();
        }
        this.pos = this.mark;
        return this;
    }

    public final Buffer rewind() {
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    final void checkForUnderflow() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
    }

    final void checkForUnderflow(int n) {
        if (this.remaining() < n) {
            throw new BufferUnderflowException();
        }
    }

    final void checkForOverflow() {
        if (!this.hasRemaining()) {
            throw new BufferOverflowException();
        }
    }

    final void checkForOverflow(int n) {
        if (this.remaining() < n) {
            throw new BufferOverflowException();
        }
    }

    final void checkIndex(int n) {
        if (n < 0 || n >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
    }

    final void checkIfReadOnly() {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
    }

    static final void checkArraySize(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n < n3 + n2) {
            throw new IndexOutOfBoundsException();
        }
    }

    public abstract Object array();

    public abstract boolean hasArray();

    public abstract int arrayOffset();

    public abstract boolean isDirect();
}

