/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

final class VMNetworkInterface {
    String name;
    Set addresses;

    VMNetworkInterface(String string) {
        this.name = string;
        this.addresses = new HashSet();
    }

    public VMNetworkInterface() {
        this.addresses = new HashSet();
        try {
            this.addresses.add(InetAddress.getByName("0.0.0.0"));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private static native void initIds();

    public static native VMNetworkInterface[] getVMInterfaces() throws SocketException;

    private void addAddress(ByteBuffer byteBuffer) throws SocketException, UnknownHostException {
        if (byteBuffer.remaining() == 4) {
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            this.addresses.add(Inet4Address.getByAddress(byArray));
        } else if (byteBuffer.remaining() == 16) {
            byte[] byArray = new byte[16];
            byteBuffer.get(byArray);
            this.addresses.add(Inet6Address.getByAddress(byArray));
        } else {
            throw new SocketException("invalid interface address");
        }
    }

    static native boolean isUp(String var0) throws SocketException;

    static native boolean isLoopback(String var0) throws SocketException;

    static native boolean isPointToPoint(String var0) throws SocketException;

    static native boolean supportsMulticast(String var0) throws SocketException;

    static {
        System.loadLibrary("javanet");
        VMNetworkInterface.initIds();
    }
}

