/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.PlainSocketImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;

public class Socket {
    static SocketImplFactory factory;
    SocketImpl impl;
    boolean implCreated;
    boolean bound;
    private boolean inputShutdown;
    private boolean outputShutdown;

    public Socket() {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.impl = socketImpl == null ? new PlainSocketImpl() : socketImpl;
    }

    public Socket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, null, 0, true);
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, null, 0, true);
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2, true);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress, n, inetAddress2, n2, true);
    }

    public Socket(String string, int n, boolean bl) throws IOException {
        this(InetAddress.getByName(string), n, null, 0, bl);
    }

    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this(inetAddress, n, null, 0, bl);
    }

    private Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, boolean bl) throws IOException {
        this();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetAddress.getHostAddress(), n);
        }
        InetSocketAddress inetSocketAddress = inetAddress2 == null ? null : new InetSocketAddress(inetAddress2, n2);
        this.bind(inetSocketAddress);
        try {
            this.connect(new InetSocketAddress(inetAddress, n));
        }
        catch (IOException iOException) {
            this.impl.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.impl.close();
            throw runtimeException;
        }
    }

    private SocketImpl getImpl() throws SocketException {
        if (!this.implCreated) {
            try {
                this.impl.create(true);
            }
            catch (IOException iOException) {
                throw (SocketException)new SocketException().initCause(iOException);
            }
            this.implCreated = true;
        }
        return this.impl;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(InetAddress.ANY_IF, 0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        try {
            this.getImpl().bind(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.bound = true;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        catch (Error error) {
            this.close();
            throw error;
        }
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((PlainSocketImpl)this.getImpl()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        if (!this.isBound()) {
            this.bind(null);
        }
        this.getImpl().connect(socketAddress, n);
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        SecurityManager securityManager;
        if (!this.isBound()) {
            return InetAddress.ANY_IF;
        }
        InetAddress inetAddress = null;
        if (this.impl instanceof PlainSocketImpl) {
            inetAddress = ((PlainSocketImpl)this.impl).getLocalAddress().getAddress();
        }
        if (inetAddress == null) {
            try {
                inetAddress = (InetAddress)this.getImpl().getOption(15);
            }
            catch (SocketException socketException) {
                return null;
            }
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(inetAddress.getHostName(), this.getLocalPort());
        }
        return inetAddress;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return 0;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            if (this.getImpl() != null) {
                return this.getImpl().getLocalPort();
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return -1;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        InetAddress inetAddress = this.getLocalAddress();
        try {
            return new InetSocketAddress(inetAddress, this.getImpl().getLocalPort());
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return new InetSocketAddress(this.getImpl().getInetAddress(), this.getImpl().getPort());
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!this.isConnected()) {
            throw new IOException("not connected");
        }
        return this.getImpl().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!this.isConnected()) {
            throw new IOException("not connected");
        }
        return this.getImpl().getOutputStream();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(1, bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(1);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SocketException("Internal Error");
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (bl) {
            if (n < 0) {
                throw new IllegalArgumentException("SO_LINGER must be >= 0");
            }
            if (n > 65535) {
                n = 65535;
            }
            this.getImpl().setOption(128, n);
        } else {
            this.getImpl().setOption(128, -1);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public void sendUrgentData(int n) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().sendUrgentData(n);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(4099, bl);
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4099);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.getImpl().setOption(4102, n);
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("SO_SNDBUF value must be > 0");
        }
        this.getImpl().setOption(4097, n);
    }

    public int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4097);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.getImpl().setOption(4098, n);
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(8, bl);
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(8);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.impl.close();
        this.impl = null;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return super.toString() + " [addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return super.toString() + " [unconnected]";
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("SocketImplFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (socketImplFactory == null) {
            throw new SocketException("SocketImplFactory cannot be null");
        }
        factory = socketImplFactory;
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().shutdownInput();
        this.inputShutdown = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().shutdownOutput();
        this.outputShutdown = true;
    }

    public SocketChannel getChannel() {
        return null;
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4);
        if (!(object instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)object;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(4, bl);
    }

    public int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(3);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("Unexpected type");
    }

    public void setTrafficClass(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.getImpl().setOption(3, n);
    }

    public boolean isConnected() {
        if (this.impl == null) {
            return false;
        }
        return this.impl.getInetAddress() != null;
    }

    public boolean isBound() {
        if (this.isClosed()) {
            return false;
        }
        if (this.impl instanceof PlainSocketImpl) {
            InetSocketAddress inetSocketAddress = ((PlainSocketImpl)this.impl).getLocalAddress();
            return inetSocketAddress != null && inetSocketAddress.getAddress() != null;
        }
        return this.bound;
    }

    public boolean isClosed() {
        SocketChannel socketChannel = this.getChannel();
        return this.impl == null || socketChannel != null && !socketChannel.isOpen();
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }
}

