/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.PlainSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl impl;
    private InetSocketAddress local;
    private int port;

    ServerSocket(PlainSocketImpl plainSocketImpl) throws IOException {
        if (plainSocketImpl == null) {
            throw new NullPointerException("impl may not be null");
        }
        this.impl = plainSocketImpl;
        this.impl.create(true);
        this.setReuseAddress(true);
    }

    SocketImpl getImpl() {
        return this.impl;
    }

    public ServerSocket() throws IOException {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
        this.impl.create(true);
    }

    public ServerSocket(int n) throws IOException {
        this(n, 50);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this();
        this.bind(new InetSocketAddress(inetAddress, n), n2);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress, int n) throws IOException {
        Object object;
        int n2;
        InetAddress inetAddress;
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress == null) {
            inetAddress = InetAddress.ANY_IF;
            n2 = 0;
        } else {
            if (!(socketAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Address type not supported");
            }
            object = (InetSocketAddress)socketAddress;
            if (((InetSocketAddress)object).isUnresolved()) {
                throw new SocketException("Unresolved address");
            }
            inetAddress = ((InetSocketAddress)object).getAddress();
            n2 = ((InetSocketAddress)object).getPort();
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkListen(n2);
        }
        try {
            this.impl.bind(inetAddress, n2);
            this.impl.listen(n);
            this.port = n2;
            this.local = new InetSocketAddress((InetAddress)this.impl.getOption(15), this.impl.getLocalPort());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (this.local == null) {
                    this.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (this.local == null) {
                this.close();
            }
        }
        catch (IOException iOException) {}
    }

    public InetAddress getInetAddress() {
        if (this.local == null) {
            return null;
        }
        return this.local.getAddress();
    }

    public int getLocalPort() {
        if (this.local == null) {
            return -1;
        }
        return this.local.getPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.local;
    }

    public Socket accept() throws IOException {
        Socket socket = new Socket();
        try {
            this.implAccept(socket);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        catch (SecurityException securityException) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw securityException;
        }
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((PlainSocketImpl)this.getImpl()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.accept(socket.impl);
        socket.bound = true;
        socket.implCreated = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccept(socket.getInetAddress().getHostAddress(), socket.getPort());
        }
    }

    public void close() throws IOException {
        if (this.impl != null) {
            this.impl.close();
            this.impl = null;
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.local != null;
    }

    public boolean isClosed() {
        ServerSocketChannel serverSocketChannel = this.getChannel();
        return this.impl == null || serverSocketChannel != null && !serverSocketChannel.isOpen();
    }

    public void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, n);
    }

    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object object = this.impl.getOption(4102);
        if (!(object instanceof Integer)) {
            throw new IOException("Internal Error");
        }
        return (Integer)object;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        this.impl.setOption(4, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object object = this.impl.getOption(4);
        if (!(object instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)object;
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.impl.setOption(4098, n);
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object object = this.impl.getOption(4098);
        if (!(object instanceof Integer)) {
            throw new SocketException("Internal Error: Unexpected type");
        }
        return (Integer)object;
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",port=" + this.port + ",localport=" + this.getLocalPort() + "]";
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("SocketFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }
}

