/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.UnknownHostException;
import java.net.VMInetAddress;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class ResolverCache {
    private static final int POSITIVE_TTL = ResolverCache.getTTL("networkaddress.cache.ttl", -1);
    private static final int NEGATIVE_TTL = ResolverCache.getTTL("networkaddress.cache.negative.ttl", 10);
    private static HashMap<Object, Entry> cache = new HashMap();
    private static LinkedList<Entry> killqueue = new LinkedList();

    ResolverCache() {
    }

    private static int getTTL(String string, int n) {
        String string2 = Security.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public static String getHostByAddr(byte[] byArray) throws UnknownHostException {
        Object object = ResolverCache.makeHashableAddress(byArray);
        Entry entry = ResolverCache.get(object);
        if (entry != null) {
            if (entry.value == null) {
                throw new UnknownHostException();
            }
            return (String)entry.value;
        }
        try {
            String string = VMInetAddress.getHostByAddr(byArray);
            ResolverCache.put(new Entry(object, string));
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            ResolverCache.put(new Entry(object, null));
            throw unknownHostException;
        }
    }

    public static byte[][] getHostByName(String string) throws UnknownHostException {
        Entry entry = ResolverCache.get(string);
        if (entry != null) {
            if (entry.value == null) {
                throw new UnknownHostException();
            }
            return (byte[][])entry.value;
        }
        try {
            byte[][] byArray = VMInetAddress.getHostByName(string);
            ResolverCache.put(new Entry(string, byArray));
            return byArray;
        }
        catch (UnknownHostException unknownHostException) {
            ResolverCache.put(new Entry(string, null));
            throw unknownHostException;
        }
    }

    private static Object makeHashableAddress(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray);
    }

    private static synchronized Entry get(Object object) {
        ResolverCache.reap();
        return cache.get(object);
    }

    private static synchronized void put(Entry entry) {
        ResolverCache.reap();
        if (entry.expires != 0L) {
            if (entry.expires != -1L) {
                killqueue.add(entry);
            }
            cache.put(entry.key, entry);
        }
    }

    private static void reap() {
        if (!killqueue.isEmpty()) {
            long l = System.currentTimeMillis();
            Iterator iterator = killqueue.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry.expires > l) break;
                cache.remove(entry.key);
                iterator.remove();
            }
        }
    }

    private static class Entry {
        public final Object key;
        public final Object value;
        public final long expires;

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
            int n = object2 != null ? POSITIVE_TTL : NEGATIVE_TTL;
            this.expires = n < 1 ? (long)n : System.currentTimeMillis() + (long)(n * 1000);
        }
    }
}

