/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    byte[] ipaddress;
    private int scope_id;
    private boolean scope_id_set;
    private boolean scope_ifname_set;
    private String ifname;
    private transient NetworkInterface nif;
    private static final int AF_INET6 = 10;

    Inet6Address(byte[] byArray, String string) {
        super(byArray, string, 10);
        this.ipaddress = this.addr;
        this.ifname = null;
        this.scope_id_set = false;
        this.scope_ifname_set = false;
        this.scope_id = 0;
        this.nif = null;
    }

    public boolean isMulticastAddress() {
        return this.ipaddress[0] == -1;
    }

    public boolean isAnyLocalAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return Arrays.equals(this.ipaddress, byArray);
    }

    public boolean isLoopbackAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        return Arrays.equals(this.ipaddress, byArray);
    }

    public boolean isLinkLocalAddress() {
        return this.ipaddress[0] == 250;
    }

    public boolean isSiteLocalAddress() {
        return this.ipaddress[0] == 251;
    }

    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 8;
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, int n) throws UnknownHostException {
        if (byArray.length != 16) {
            throw new UnknownHostException("Illegal address length: " + byArray.length + " bytes.");
        }
        Inet6Address inet6Address = new Inet6Address(byArray, string);
        inet6Address.scope_id = n;
        inet6Address.scope_id_set = true;
        return inet6Address;
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        if (byArray.length != 16) {
            throw new UnknownHostException("Illegal address length: " + byArray.length + " bytes.");
        }
        Inet6Address inet6Address = new Inet6Address(byArray, string);
        inet6Address.nif = networkInterface;
        return inet6Address;
    }

    public NetworkInterface getScopedInterface() {
        return this.nif;
    }

    public int getScopeId() {
        if (this.scope_id_set) {
            return this.scope_id;
        }
        return 0;
    }

    public String getHostAddress() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(40);
        for (int i = 0; i < 16; i += 2) {
            int n = (this.ipaddress[i] & 0xFF) << 8 | this.ipaddress[i + 1] & 0xFF;
            if (i > 0) {
                cPStringBuilder.append(':');
            }
            cPStringBuilder.append(Integer.toHexString(n));
        }
        if (this.nif != null) {
            cPStringBuilder.append("%" + this.nif.getName());
        } else if (this.scope_id_set) {
            cPStringBuilder.append("%" + this.scope_id);
        }
        return cPStringBuilder.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        if (this.ipaddress.length != inet6Address.ipaddress.length) {
            return false;
        }
        for (int i = 0; i < inet6Address.ipaddress.length; ++i) {
            if (this.ipaddress[i] == inet6Address.ipaddress[i]) continue;
            return false;
        }
        if (inet6Address.nif != null && this.nif != null) {
            return this.nif.equals(inet6Address.nif);
        }
        if (inet6Address.nif != this.nif) {
            return false;
        }
        if (inet6Address.scope_id_set != this.scope_id_set) {
            return false;
        }
        if (this.scope_id_set) {
            return this.scope_id == inet6Address.scope_id;
        }
        return true;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            if (this.scope_ifname_set) {
                this.nif = NetworkInterface.getByName(this.ifname);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.nif != null) {
            this.ifname = this.nif.getName();
            this.scope_ifname_set = true;
        }
        objectOutputStream.defaultWriteObject();
    }
}

