/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.lang.CPStringBuilder;
import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    static final long serialVersionUID = 3286316764910316507L;
    private static final int AF_INET = 2;

    private Object writeReplace() throws ObjectStreamException {
        return new InetAddress(this.addr, this.hostName, 2);
    }

    Inet4Address(byte[] byArray, String string) {
        super(byArray, string, 2);
    }

    public boolean isMulticastAddress() {
        return (this.addr[0] & 0xF0) == 224;
    }

    public boolean isLoopbackAddress() {
        return (this.addr[0] & 0xFF) == 127;
    }

    public boolean isAnyLocalAddress() {
        return this.equals(InetAddress.ANY_IF);
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if ((this.addr[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.addr[0] & 0xFF) == 172 && (this.addr[1] & 0xF0) == 16) {
            return true;
        }
        return (this.addr[0] & 0xFF) == 192 && (this.addr[1] & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.addr[0] & 0xFF) == 224 && (this.addr[1] & 0xFF) == 0 && (this.addr[2] & 0xFF) == 0;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    public String getHostAddress() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(40);
        int n = this.addr.length;
        int n2 = 0;
        while (true) {
            cPStringBuilder.append(this.addr[n2] & 0xFF);
            if (++n2 == n) break;
            cPStringBuilder.append('.');
        }
        return cPStringBuilder.toString();
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        int n3 = this.addr.length;
        int n4 = n = n3 > 4 ? n3 - 4 : 0;
        while (n < n3) {
            n2 = n2 << 8 | this.addr[n] & 0xFF;
            ++n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InetAddress)) {
            return false;
        }
        byte[] byArray = this.addr;
        byte[] byArray2 = ((InetAddress)object).addr;
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }
}

