/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.Serializable;
import java.math.RoundingMode;

public final class MathContext
implements Serializable {
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    private static final long serialVersionUID = 5579720004786848255L;
    private int precision;
    private RoundingMode roundMode;

    public MathContext(int n) {
        this(n, RoundingMode.HALF_UP);
    }

    public MathContext(int n, RoundingMode roundingMode) {
        if (n < 0) {
            throw new IllegalArgumentException("Precision cannot be less than zero.");
        }
        this.precision = n;
        this.roundMode = roundingMode;
    }

    public MathContext(String string) {
        try {
            int n = string.indexOf("roundingMode", 10);
            this.precision = Integer.parseInt(string.substring(10, n - 1));
            this.roundMode = RoundingMode.valueOf(string.substring(n + 13));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("String not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("String not in correct format");
        }
        if (this.precision < 0) {
            throw new IllegalArgumentException("Precision cannot be less than 0.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MathContext)) {
            return false;
        }
        MathContext mathContext = (MathContext)object;
        return mathContext.precision == this.precision && mathContext.roundMode.equals((Object)this.roundMode);
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundMode;
    }

    public String toString() {
        return "precision=" + this.precision + " roundingMode=" + (Object)((Object)this.roundMode);
    }

    public int hashCode() {
        return this.precision ^ this.roundMode.hashCode();
    }
}

