/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.ClassHelper;
import gnu.java.lang.reflect.MethodSignatureParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.VMMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements Member,
GenericDeclaration {
    private static final int METHOD_MODIFIERS = 3391;
    private MethodSignatureParser p;
    VMMethod m;

    Method(VMMethod vMMethod) {
        this.m = vMMethod;
        vMMethod.m = this;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.m.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.m.getName();
    }

    @Override
    public int getModifiers() {
        return this.m.getModifiersInternal() & 0xD3F;
    }

    public boolean isBridge() {
        return (this.m.getModifiersInternal() & 0x40) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.m.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.m.getModifiersInternal() & 0x80) != 0;
    }

    public Class<?> getReturnType() {
        return this.m.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.m.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return this.m.getExceptionTypes();
    }

    public boolean equals(Object object) {
        return this.m.equals(object);
    }

    public int hashCode() {
        return this.m.getDeclaringClass().getName().hashCode() ^ this.m.getName().hashCode();
    }

    public String toString() {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(128);
        Modifier.toString(this.getModifiers(), cPStringBuilder).append(' ');
        cPStringBuilder.append(ClassHelper.getUserName(this.getReturnType())).append(' ');
        cPStringBuilder.append(this.getDeclaringClass().getName()).append('.');
        cPStringBuilder.append(this.getName()).append('(');
        Class<?>[] classArray = this.getParameterTypes();
        if (classArray.length > 0) {
            cPStringBuilder.append(ClassHelper.getUserName(classArray[0]));
            for (n = 1; n < classArray.length; ++n) {
                cPStringBuilder.append(',').append(ClassHelper.getUserName(classArray[n]));
            }
        }
        cPStringBuilder.append(')');
        classArray = this.getExceptionTypes();
        if (classArray.length > 0) {
            cPStringBuilder.append(" throws ").append(classArray[0].getName());
            for (n = 1; n < classArray.length; ++n) {
                cPStringBuilder.append(',').append(classArray[n].getName());
            }
        }
        return cPStringBuilder.toString();
    }

    public String toGenericString() {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(128);
        Modifier.toString(this.getModifiers(), cPStringBuilder).append(' ');
        Constructor.addTypeParameters(cPStringBuilder, this.getTypeParameters());
        cPStringBuilder.append(this.getGenericReturnType()).append(' ');
        cPStringBuilder.append(this.getDeclaringClass().getName()).append('.');
        cPStringBuilder.append(this.getName()).append('(');
        Type[] typeArray = this.getGenericParameterTypes();
        if (typeArray.length > 0) {
            cPStringBuilder.append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                cPStringBuilder.append(',').append(typeArray[n]);
            }
        }
        cPStringBuilder.append(')');
        typeArray = this.getGenericExceptionTypes();
        if (typeArray.length > 0) {
            cPStringBuilder.append(" throws ").append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                cPStringBuilder.append(',').append(typeArray[n]);
            }
        }
        return cPStringBuilder.toString();
    }

    public Object invoke(Object object, Object ... objectArray) throws IllegalAccessException, InvocationTargetException {
        return this.m.invoke(object, objectArray);
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.p == null) {
            String string = this.m.getSignature();
            if (string == null) {
                return new TypeVariable[0];
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getTypeParameters();
    }

    public Type[] getGenericExceptionTypes() {
        if (this.p == null) {
            String string = this.m.getSignature();
            if (string == null) {
                return this.getExceptionTypes();
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getGenericExceptionTypes();
    }

    public Type[] getGenericParameterTypes() {
        if (this.p == null) {
            String string = this.m.getSignature();
            if (string == null) {
                return this.getParameterTypes();
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getGenericParameterTypes();
    }

    public Type getGenericReturnType() {
        if (this.p == null) {
            String string = this.m.getSignature();
            if (string == null) {
                return this.getReturnType();
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getGenericReturnType();
    }

    public Object getDefaultValue() {
        return this.m.getDefaultValue();
    }

    public Annotation[][] getParameterAnnotations() {
        return this.m.getParameterAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Annotation annotation = this.m.getAnnotation(clazz);
        return (T)annotation;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.m.getDeclaredAnnotations();
    }
}

