/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.ClassHelper;
import gnu.java.lang.reflect.FieldSignatureParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.VMField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field
extends AccessibleObject
implements Member {
    static final int FIELD_MODIFIERS = 223;
    private FieldSignatureParser p;
    VMField f;

    Field(VMField vMField) {
        this.f = vMField;
        vMField.f = this;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.f.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public int getModifiers() {
        return this.f.getModifiersInternal() & 0xDF;
    }

    @Override
    public boolean isSynthetic() {
        return (this.f.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isEnumConstant() {
        return (this.f.getModifiersInternal() & 0x4000) != 0;
    }

    public Class<?> getType() {
        return this.f.getType();
    }

    public boolean equals(Object object) {
        return this.f.equals(object);
    }

    public int hashCode() {
        return this.f.getDeclaringClass().getName().hashCode() ^ this.f.getName().hashCode();
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(64);
        Modifier.toString(this.getModifiers(), cPStringBuilder).append(' ');
        cPStringBuilder.append(ClassHelper.getUserName(this.getType())).append(' ');
        cPStringBuilder.append(this.getDeclaringClass().getName()).append('.');
        cPStringBuilder.append(this.getName());
        return cPStringBuilder.toString();
    }

    public String toGenericString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(64);
        Modifier.toString(this.getModifiers(), cPStringBuilder).append(' ');
        cPStringBuilder.append(this.getGenericType()).append(' ');
        cPStringBuilder.append(this.getDeclaringClass().getName()).append('.');
        cPStringBuilder.append(this.getName());
        return cPStringBuilder.toString();
    }

    public Object get(Object object) throws IllegalAccessException {
        return this.f.get(object);
    }

    public boolean getBoolean(Object object) throws IllegalAccessException {
        return this.f.getBoolean(object);
    }

    public byte getByte(Object object) throws IllegalAccessException {
        return this.f.getByte(object);
    }

    public char getChar(Object object) throws IllegalAccessException {
        return this.f.getChar(object);
    }

    public short getShort(Object object) throws IllegalAccessException {
        return this.f.getShort(object);
    }

    public int getInt(Object object) throws IllegalAccessException {
        return this.f.getInt(object);
    }

    public long getLong(Object object) throws IllegalAccessException {
        return this.f.getLong(object);
    }

    public float getFloat(Object object) throws IllegalAccessException {
        return this.f.getFloat(object);
    }

    public double getDouble(Object object) throws IllegalAccessException {
        return this.f.getDouble(object);
    }

    public void set(Object object, Object object2) throws IllegalAccessException {
        this.f.set(object, object2);
    }

    public void setBoolean(Object object, boolean bl) throws IllegalAccessException {
        this.f.setBoolean(object, bl);
    }

    public void setByte(Object object, byte by) throws IllegalAccessException {
        this.f.setByte(object, by);
    }

    public void setChar(Object object, char c) throws IllegalAccessException {
        this.f.setChar(object, c);
    }

    public void setShort(Object object, short s) throws IllegalAccessException {
        this.f.setShort(object, s);
    }

    public void setInt(Object object, int n) throws IllegalAccessException {
        this.f.setInt(object, n);
    }

    public void setLong(Object object, long l) throws IllegalAccessException {
        this.f.setLong(object, l);
    }

    public void setFloat(Object object, float f) throws IllegalAccessException {
        this.f.setFloat(object, f);
    }

    public void setDouble(Object object, double d) throws IllegalAccessException {
        this.f.setDouble(object, d);
    }

    public Type getGenericType() {
        if (this.p == null) {
            String string = this.f.getSignature();
            if (string == null) {
                return this.getType();
            }
            this.p = new FieldSignatureParser(this.getDeclaringClass(), string);
        }
        return this.p.getFieldType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Annotation annotation = this.f.getAnnotation(clazz);
        return (T)annotation;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.f.getDeclaredAnnotations();
    }
}

