/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleObject
implements AnnotatedElement {
    boolean flag = false;

    protected AccessibleObject() {
    }

    public boolean isAccessible() {
        return this.flag;
    }

    public static void setAccessible(AccessibleObject[] accessibleObjectArray, boolean bl) {
        AccessibleObject.checkPermission();
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            accessibleObjectArray[i].secureSetAccessible(bl);
        }
    }

    public void setAccessible(boolean bl) {
        AccessibleObject.checkPermission();
        this.secureSetAccessible(bl);
    }

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
        }
    }

    private void secureSetAccessible(boolean bl) {
        if (bl && this instanceof Constructor && ((Constructor)this).getDeclaringClass() == Class.class) {
            throw new SecurityException("Cannot make object accessible: " + this);
        }
        this.flag = bl;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        throw new AssertionError((Object)"Subclass must override this method");
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"Subclass must override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }
}

