/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reference<T> {
    T referent;
    volatile ReferenceQueue<? super T> queue;
    volatile Reference nextOnQueue;
    static Object lock = new Object();

    Reference(T t) {
        this.referent = t;
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        if (referenceQueue == null) {
            throw new NullPointerException();
        }
        this.referent = t;
        this.queue = referenceQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = lock;
        synchronized (object) {
            return this.referent;
        }
    }

    public void clear() {
        this.referent = null;
    }

    public boolean isEnqueued() {
        return this.nextOnQueue != null;
    }

    public boolean enqueue() {
        ReferenceQueue<T> referenceQueue = this.queue;
        if (referenceQueue != null) {
            return referenceQueue.enqueue(this);
        }
        return false;
    }
}

