/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ThreadInfo {
    private long threadId;
    private String threadName;
    private Thread.State threadState;
    private long blockedCount;
    private long blockedTime;
    private String lockName;
    private long lockOwnerId;
    private String lockOwnerName;
    private long waitedCount;
    private long waitedTime;
    private boolean isInNative;
    private boolean isSuspended;
    private StackTraceElement[] trace;
    private MonitorInfo[] lockedMonitors;
    private LockInfo[] lockedSynchronizers;
    private static ThreadMXBean bean = null;
    private static CompositeType seType;

    private ThreadInfo(long l, String string, Thread.State state, long l2, long l3, String string2, long l4, String string3, long l5, long l6, boolean bl, boolean bl2, StackTraceElement[] stackTraceElementArray, MonitorInfo[] monitorInfoArray, LockInfo[] lockInfoArray) {
        this.threadId = l;
        this.threadName = string;
        this.threadState = state;
        this.blockedCount = l2;
        this.blockedTime = l3;
        this.lockName = string2;
        this.lockOwnerId = l4;
        this.lockOwnerName = string3;
        this.waitedCount = l5;
        this.waitedTime = l6;
        this.isInNative = bl;
        this.isSuspended = bl2;
        this.trace = stackTraceElementArray;
        this.lockedMonitors = monitorInfoArray;
        this.lockedSynchronizers = lockInfoArray;
    }

    static void checkAttribute(CompositeType compositeType, String string, OpenType openType) throws IllegalArgumentException {
        OpenType<?> openType2 = compositeType.getType(string);
        if (openType2 == null) {
            throw new IllegalArgumentException("Could not find a field named " + string);
        }
        if (!openType2.equals(openType)) {
            throw new IllegalArgumentException("Field " + string + " is not of type " + openType.getClassName());
        }
    }

    static CompositeType getStackTraceType() {
        if (seType == null) {
            try {
                seType = new CompositeType(StackTraceElement.class.getName(), "An element of a stack trace", new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"}, new String[]{"Name of the class", "Name of the method", "Name of the source code file", "Line number", "True if this is a native method"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN});
            }
            catch (OpenDataException openDataException) {
                throw new IllegalStateException("Something went wrong in creating the composite data type for the stack trace element.", openDataException);
            }
        }
        return seType;
    }

    public static ThreadInfo from(CompositeData compositeData) {
        MonitorInfo[] monitorInfoArray;
        Object[] objectArray;
        Object object;
        if (compositeData == null) {
            return null;
        }
        CompositeType compositeType = compositeData.getCompositeType();
        ThreadInfo.checkAttribute(compositeType, "ThreadId", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "ThreadName", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "ThreadState", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "Suspended", SimpleType.BOOLEAN);
        ThreadInfo.checkAttribute(compositeType, "InNative", SimpleType.BOOLEAN);
        ThreadInfo.checkAttribute(compositeType, "BlockedCount", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "BlockedTime", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "WaitedCount", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "WaitedTime", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "LockName", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "LockOwnerId", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "LockOwnerName", SimpleType.STRING);
        try {
            ThreadInfo.checkAttribute(compositeType, "StackTrace", new ArrayType(1, ThreadInfo.getStackTraceType()));
        }
        catch (OpenDataException openDataException) {
            throw new IllegalStateException("Something went wrong in creating the array for the stack trace element.", openDataException);
        }
        OpenType<?> openType = compositeType.getType("LockedMonitors");
        if (openType != null) {
            try {
                object = new CompositeType(MonitorInfo.class.getName(), "Information on a object monitor lock", new String[]{"ClassName", "IdentityHashCode", "LockedStackDepth", "LockedStackFrame"}, new String[]{"Name of the class", "Identity hash code of the class", "Stack depth at time of lock", "Stack frame at time of lock"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, ThreadInfo.getStackTraceType()});
                if (!openType.equals(new ArrayType(1, (OpenType<?>)object))) {
                    throw new IllegalArgumentException("Field LockedMonitors is not of type " + ((OpenType)object).getClassName());
                }
            }
            catch (OpenDataException openDataException) {
                throw new IllegalStateException("Something went wrong in creating the composite data type for the object monitor information array.", openDataException);
            }
        }
        if ((openType = compositeType.getType("LockedSynchronizers")) != null) {
            try {
                object = new CompositeType(LockInfo.class.getName(), "Information on a lock", new String[]{"ClassName", "IdentityHashCode"}, new String[]{"Name of the class", "Identity hash code of the class"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER});
                if (!openType.equals(new ArrayType(1, (OpenType<?>)object))) {
                    throw new IllegalArgumentException("Field LockedSynchronizers is not of type " + ((OpenType)object).getClassName());
                }
            }
            catch (OpenDataException openDataException) {
                throw new IllegalStateException("Something went wrong in creating the composite data type for the ownable synchronizerinformation array.", openDataException);
            }
        }
        object = (CompositeData[])compositeData.get("StackTrace");
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[((CompositeData[])object).length];
        for (int i = 0; i < ((CompositeData[])object).length; ++i) {
            stackTraceElementArray[i] = new StackTraceElement((String)object[i].get("ClassName"), (String)object[i].get("MethodName"), (String)object[i].get("FileName"), (Integer)object[i].get("LineNumber"));
        }
        if (compositeData.containsKey("LockedMonitors")) {
            objectArray = (CompositeData[])compositeData.get("LockedMonitors");
            monitorInfoArray = new MonitorInfo[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                monitorInfoArray[i] = MonitorInfo.from((CompositeData)objectArray[i]);
            }
        } else {
            monitorInfoArray = new MonitorInfo[]{};
        }
        if (compositeData.containsKey("LockedSynchronizers")) {
            CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("LockedSynchronizers");
            objectArray = new LockInfo[compositeDataArray.length];
            for (int i = 0; i < compositeDataArray.length; ++i) {
                objectArray[i] = new LockInfo((String)compositeDataArray[i].get("ClassName"), (Integer)compositeDataArray[i].get("IdentityHashCode"));
            }
        } else {
            objectArray = new LockInfo[]{};
        }
        return new ThreadInfo((Long)compositeData.get("ThreadId"), (String)compositeData.get("ThreadName"), Thread.State.valueOf((String)compositeData.get("ThreadState")), (Long)compositeData.get("BlockedCount"), (Long)compositeData.get("BlockedTime"), (String)compositeData.get("LockName"), (Long)compositeData.get("LockOwnerId"), (String)compositeData.get("LockOwnerName"), (Long)compositeData.get("WaitedCount"), (Long)compositeData.get("WaitedTime"), (Boolean)compositeData.get("InNative"), (Boolean)compositeData.get("Suspended"), stackTraceElementArray, monitorInfoArray, (LockInfo[])objectArray);
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        if (bean == null) {
            bean = ManagementFactory.getThreadMXBean();
        }
        if (bean.isThreadContentionMonitoringEnabled()) {
            return this.blockedTime;
        }
        return -1L;
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public LockInfo getLockInfo() {
        String string = this.getLockName();
        int n = string.indexOf(64);
        return new LockInfo(string.substring(0, n), Integer.decode(string.substring(n + 1)));
    }

    public String getLockName() {
        if (!this.isThreadBlocked()) {
            return null;
        }
        return this.lockName;
    }

    public long getLockOwnerId() {
        if (!this.isThreadBlocked()) {
            return -1L;
        }
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        if (!this.isThreadBlocked()) {
            return null;
        }
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.trace;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        if (bean == null) {
            bean = ManagementFactory.getThreadMXBean();
        }
        if (bean.isThreadContentionMonitoringEnabled()) {
            return this.waitedTime;
        }
        return -1L;
    }

    public boolean isInNative() {
        return this.isInNative;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.threadId + ", name=" + this.threadName + ", state=" + (Object)((Object)this.threadState) + ", blockedCount=" + this.blockedCount + ", waitedCount=" + this.waitedCount + ", isInNative=" + this.isInNative + ", isSuspended=" + this.isSuspended + (this.isThreadBlocked() ? ", lockOwnerId=" + this.lockOwnerId + ", lockOwnerName=" + this.lockOwnerName : "") + ", lockedMonitors=" + Arrays.toString(this.lockedMonitors) + ", lockedSynchronizers=" + Arrays.toString(this.lockedSynchronizers) + "]";
    }

    private boolean isThreadBlocked() {
        return this.threadState == Thread.State.BLOCKED || this.threadState == Thread.State.WAITING || this.threadState == Thread.State.TIMED_WAITING;
    }
}

