/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.java.lang.InstrumentationImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;

final class VMClassLoader {
    static final HashMap definedPackages = new HashMap();
    static final HashMap bootjars = new HashMap();
    static final Instrumentation instrumenter;

    private VMClassLoader() {
    }

    static final native Class defineClass(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5) throws ClassFormatError;

    static final native void resolveClass(Class var0);

    static final native Class loadClass(String var0, boolean var1) throws ClassNotFoundException;

    static URL getResource(String string) {
        Enumeration enumeration = VMClassLoader.getResources(string);
        if (enumeration.hasMoreElements()) {
            return (URL)enumeration.nextElement();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Enumeration getResources(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(SystemProperties.getProperty("java.boot.class.path", "."), File.pathSeparator);
        Vector<URL> vector = new Vector<URL>();
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            File file = new File(stringTokenizer.nextToken());
            if (file.isDirectory()) {
                try {
                    object = new File(file, string);
                    if (!((File)object).exists()) continue;
                    vector.add(new URL("file://" + ((File)object).getAbsolutePath()));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new Error(malformedURLException);
                }
            }
            if (!file.isFile()) continue;
            Object object2 = bootjars;
            synchronized (object2) {
                object = (ZipFile)bootjars.get(file.getName());
            }
            if (object == null) {
                try {
                    object = new ZipFile(file);
                    object2 = bootjars;
                    synchronized (object2) {
                        bootjars.put(file.getName(), object);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            Object object3 = object2 = string.startsWith("/") ? string.substring(1) : string;
            if (((ZipFile)object).getEntry((String)object2) == null) continue;
            try {
                vector.add(new URL("jar:file://" + file.getAbsolutePath() + "!/" + (String)object2));
            }
            catch (MalformedURLException malformedURLException) {
                throw new Error(malformedURLException);
            }
        }
        return vector.elements();
    }

    private static String[] getBootPackages() {
        URL uRL = VMClassLoader.getResource("META-INF/INDEX.LIST");
        if (uRL != null) {
            try {
                String string;
                HashSet<String> hashSet = new HashSet<String>();
                int n = 3;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    if (n == 0) {
                        if (string.length() == 0) {
                            n = 1;
                            continue;
                        }
                        hashSet.add(string.replace('/', '.'));
                        continue;
                    }
                    --n;
                }
                bufferedReader.close();
                return hashSet.toArray(new String[hashSet.size()]);
            }
            catch (IOException iOException) {
                return new String[0];
            }
        }
        return new String[0];
    }

    static Package getPackage(String string) {
        return (Package)definedPackages.get(string);
    }

    static Package[] getPackages() {
        Package[] packageArray = new Package[definedPackages.size()];
        definedPackages.values().toArray(packageArray);
        return packageArray;
    }

    static final native Class getPrimitiveClass(char var0);

    static final boolean defaultAssertionStatus() {
        return true;
    }

    static final Map packageAssertionStatus() {
        return new HashMap();
    }

    static final Map classAssertionStatus() {
        return new HashMap();
    }

    static ClassLoader getSystemClassLoader() {
        return ClassLoader.defaultGetSystemClassLoader();
    }

    static native Class findLoadedClass(ClassLoader var0, String var1);

    static final Class defineClassWithTransformers(ClassLoader classLoader, String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) {
        if (instrumenter != null) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            String string2 = string.replace('.', '/');
            byArray2 = ((InstrumentationImpl)instrumenter).callTransformers(classLoader, string2, null, protectionDomain, byArray2);
            return VMClassLoader.defineClass(classLoader, string, byArray2, 0, byArray2.length, protectionDomain);
        }
        return VMClassLoader.defineClass(classLoader, string, byArray, n, n2, protectionDomain);
    }

    static {
        String[] stringArray = VMClassLoader.getBootPackages();
        if (stringArray != null) {
            String string = SystemProperties.getProperty("java.specification.name");
            String string2 = SystemProperties.getProperty("java.specification.vendor");
            String string3 = SystemProperties.getProperty("java.specification.version");
            for (int i = 0; i < stringArray.length; ++i) {
                Package package_ = new Package(stringArray[i], string, string2, string3, "GNU Classpath", "GNU", "0.99", null, null);
                definedPackages.put(stringArray[i], package_);
            }
        }
        instrumenter = null;
    }
}

