/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThreadLocalMap {
    private static final int LOG_INITIAL_SIZE = 3;
    private static final float MAX_OCCUPANCY = 0.7f;
    private static final float TARGET_OCCUPANCY = 0.5f;
    private static final Entry deletedEntry = new Entry(null);
    private Entry[] entries = new Entry[1];
    private int hashMask = 0;
    private int count = 0;

    ThreadLocalMap() {
    }

    private void newEntryArray(int n) {
        int n2 = n - 1;
        Entry[] entryArray = this.entries;
        this.entries = new Entry[n];
        this.hashMask = n2;
        this.count = 0;
        if (entryArray != null) {
            block0: for (Entry entry : entryArray) {
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)entry.get();
                if (entry == deletedEntry || threadLocal == null) continue;
                int n3 = threadLocal.fastHash & n2;
                while (true) {
                    if (this.entries[n3] == null) {
                        this.entries[n3] = entry;
                        ++this.count;
                        continue block0;
                    }
                    n3 = n3 + 1 & n2;
                }
            }
        }
    }

    private void overflow() {
        if (this.entries.length == 1) {
            this.newEntryArray(8);
            return;
        }
        int n = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            Entry entry = this.entries[i];
            if (entry == null) continue;
            if (entry == deletedEntry) {
                ++n;
                continue;
            }
            if (entry.get() != null) continue;
            this.entries[i] = deletedEntry;
            ++n;
        }
        if ((float)(this.count - n) <= 0.5f * (float)this.entries.length) {
            this.newEntryArray(this.entries.length);
            return;
        }
        this.newEntryArray(this.entries.length << 1);
    }

    public Object get(ThreadLocal<?> threadLocal) {
        int n = this.hashMask;
        int n2 = threadLocal.fastHash & n;
        while (true) {
            Entry entry;
            if ((entry = this.entries[n2]) != null) {
                if (entry.get() == threadLocal) {
                    return entry.value;
                }
            } else {
                return ThreadLocal.sentinel;
            }
            n2 = n2 + 1 & n;
        }
    }

    public void set(ThreadLocal<?> threadLocal, Object object) {
        if ((float)(this.count + 1) >= 0.7f * (float)this.entries.length) {
            this.overflow();
        }
        int n = this.hashMask;
        int n2 = threadLocal.fastHash & n;
        while (true) {
            Entry entry;
            if ((entry = this.entries[n2]) == null || entry == deletedEntry) {
                if (entry == null) {
                    ++this.count;
                }
                this.entries[n2] = entry = new Entry(threadLocal);
                entry.value = object;
                return;
            }
            ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
            if (threadLocal2 == null) {
                this.entries[n2] = deletedEntry;
            } else if (threadLocal2 == threadLocal) {
                entry.value = object;
                return;
            }
            n2 = n2 + 1 & n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(ThreadLocal<?> threadLocal) {
        Entry entry;
        int n = this.hashMask;
        int n2 = threadLocal.fastHash & n;
        while ((entry = this.entries[n2]) != null) {
            ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
            if (threadLocal2 != threadLocal) {
                if (threadLocal2 == null) {
                    this.entries[n2] = deletedEntry;
                }
            } else {
                this.entries[n2] = deletedEntry;
                return;
            }
            n2 = n2 + 1 & n;
        }
    }

    void clear() {
        this.entries = null;
    }

    public void inherit(ThreadLocalMap threadLocalMap) {
        for (Entry entry : threadLocalMap.entries) {
            ThreadLocal threadLocal;
            if (entry == null || entry == deletedEntry || !((threadLocal = (ThreadLocal)entry.get()) instanceof InheritableThreadLocal)) continue;
            this.set(threadLocal, ((InheritableThreadLocal)threadLocal).childValue(entry.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry
    extends WeakReference<ThreadLocal<?>> {
        Object value;

        Entry(ThreadLocal<?> threadLocal) {
            super(threadLocal);
        }
    }
}

