/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in = VMSystem.makeStandardInputStream();
    public static final PrintStream out = VMSystem.makeStandardOutputStream();
    public static final PrintStream err = VMSystem.makeStandardErrorStream();
    private static Map<String, String> environmentMap;

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setIn(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setOut(printStream);
    }

    public static void setErr(PrintStream printStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setErr(printStream);
    }

    public static synchronized void setSecurityManager(SecurityManager securityManager) {
        if (SecurityManager.current != null) {
            SecurityManager.current.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (SecurityManager.current == null) {
            try {
                Class.forName("java.security.Security");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        SecurityManager.current = securityManager;
    }

    public static SecurityManager getSecurityManager() {
        return SecurityManager.current;
    }

    public static long currentTimeMillis() {
        return VMSystem.currentTimeMillis();
    }

    public static long nanoTime() {
        return VMSystem.nanoTime();
    }

    public static void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        VMSystem.arraycopy(object, n, object2, n2, n3);
    }

    public static int identityHashCode(Object object) {
        return VMSystem.identityHashCode(object);
    }

    public static Properties getProperties() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return SystemProperties.getProperties();
    }

    public static void setProperties(Properties properties) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        SystemProperties.setProperties(properties);
    }

    public static String getProperty(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.setProperty(string, string2);
    }

    public static String clearProperty(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.remove(string);
    }

    public static String getenv(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return VMSystem.getenv(string);
    }

    public static Map<String, String> getenv() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        if (environmentMap == null) {
            EnvironmentMap environmentMap = new EnvironmentMap();
            List list2 = VMSystem.environ();
            for (String string : list2) {
                if (string == null || string.endsWith("=")) continue;
                int n = string.indexOf(61);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                environmentMap.put(string2, string3);
            }
            System.environmentMap = Collections.unmodifiableMap(environmentMap);
        }
        return environmentMap;
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        Runtime.getRuntime().load(string, VMStackWalker.getCallingClassLoader());
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string, VMStackWalker.getCallingClassLoader());
    }

    public static String mapLibraryName(String string) {
        return VMRuntime.mapLibraryName(string);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    public static Console console() {
        return Console.console();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentSet
    extends EnvironmentCollection
    implements Set<String> {
        public EnvironmentSet(Set<String> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnvironmentMap
    extends HashMap<String, String> {
        private transient Set<Map.Entry<String, String>> entries;
        private transient Set<String> keys;
        private transient Collection<String> values;

        EnvironmentMap() {
        }

        EnvironmentMap(Map<String, String> map) {
            super(map);
        }

        @Override
        public boolean containsKey(Object object) {
            if (object == null) {
                throw new NullPointerException("This map does not support null keys.");
            }
            if (!(object instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return super.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            if (object == null) {
                throw new NullPointerException("This map does not support null values.");
            }
            if (!(object instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return super.containsValue(object);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this.entries == null) {
                this.entries = super.entrySet();
            }
            return this.entries;
        }

        @Override
        public String get(Object object) {
            if (object == null) {
                throw new NullPointerException("This map does not support null keys.");
            }
            if (!(object instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return (String)super.get(object);
        }

        @Override
        public Set<String> keySet() {
            if (this.keys == null) {
                this.keys = new EnvironmentSet(super.keySet());
            }
            return this.keys;
        }

        @Override
        public String put(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("A new key is null.");
            }
            if (string2 == null) {
                throw new NullPointerException("A new value is null.");
            }
            if (!(string instanceof String)) {
                throw new ClassCastException("A new key is not a String.");
            }
            if (!(string2 instanceof String)) {
                throw new ClassCastException("A new value is not a String.");
            }
            return super.put(string, string2);
        }

        @Override
        public String remove(Object object) {
            if (object == null) {
                throw new NullPointerException("This map does not support null keys.");
            }
            if (!(object instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return (String)super.remove(object);
        }

        @Override
        public Collection<String> values() {
            if (this.values == null) {
                this.values = new EnvironmentCollection(super.values());
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentCollection
    extends AbstractCollection<String> {
        protected Collection<String> c;

        public EnvironmentCollection(Collection<String> collection) {
            this.c = collection;
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                throw new NullPointerException("This collection does not support null values.");
            }
            if (!(object instanceof String)) {
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj == null) {
                    throw new NullPointerException("This collection does not support null values.");
                }
                if (obj instanceof String) continue;
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.containsAll(collection);
        }

        @Override
        public Iterator<String> iterator() {
            return this.c.iterator();
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                throw new NullPointerException("This collection does not support null values.");
            }
            if (!(object instanceof String)) {
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.contains(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj == null) {
                    throw new NullPointerException("This collection does not support null values.");
                }
                if (obj instanceof String) continue;
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj == null) {
                    throw new NullPointerException("This collection does not support null values.");
                }
                if (obj instanceof String) continue;
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.containsAll(collection);
        }

        @Override
        public int size() {
            return this.c.size();
        }
    }
}

