/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String fileName;
    private final int lineNumber;
    private final String declaringClass;
    private final String methodName;
    private final transient boolean isNative;

    StackTraceElement(String string, int n, String string2, String string3, boolean bl) {
        this.fileName = string;
        this.lineNumber = n;
        this.declaringClass = string2;
        this.methodName = string3;
        this.isNative = bl;
    }

    public StackTraceElement(String string, String string2, String string3, int n) {
        this(string3, n, string, string2, n == -2);
        if (string == null || string2 == null) {
            throw new NullPointerException("invalid argument to constructor");
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.isNative;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.declaringClass != null) {
            stringBuilder.append(this.declaringClass);
            if (this.methodName != null) {
                stringBuilder.append('.');
            }
        }
        if (this.methodName != null) {
            stringBuilder.append(this.methodName);
        }
        stringBuilder.append("(");
        if (this.fileName != null) {
            stringBuilder.append(this.fileName);
        } else {
            stringBuilder.append(this.isNative ? "Native Method" : "Unknown Source");
        }
        if (this.lineNumber >= 0) {
            stringBuilder.append(':').append(this.lineNumber);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        return StackTraceElement.equals(this.fileName, stackTraceElement.fileName) && this.lineNumber == stackTraceElement.lineNumber && StackTraceElement.equals(this.declaringClass, stackTraceElement.declaringClass) && StackTraceElement.equals(this.methodName, stackTraceElement.methodName);
    }

    public int hashCode() {
        return StackTraceElement.hashCode(this.fileName) ^ this.lineNumber ^ StackTraceElement.hashCode(this.declaringClass) ^ StackTraceElement.hashCode(this.methodName);
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

