/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessBuilder {
    private File directory = new File(System.getProperty("user.dir"));
    private List<String> command;
    private Map<String, String> environment = new System.EnvironmentMap(System.getenv());
    private boolean redirect = false;

    public ProcessBuilder(List<String> list2) {
        this.command = list2;
    }

    public ProcessBuilder(String ... stringArray) {
        this.command = Arrays.asList(stringArray);
    }

    public List<String> command() {
        return this.command;
    }

    public ProcessBuilder command(List<String> list2) {
        this.command = list2;
        return this;
    }

    public ProcessBuilder command(String ... stringArray) {
        this.command = Arrays.asList(stringArray);
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File file) {
        this.directory = file;
        return this;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public boolean redirectErrorStream() {
        return this.redirect;
    }

    public ProcessBuilder redirectErrorStream(boolean bl) {
        this.redirect = bl;
        return this;
    }

    public Process start() throws IOException {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExec(this.command.get(0));
        }
        return VMProcess.exec(this.command, this.environment, this.directory, this.redirect);
    }
}

