/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.VMStackWalker;
import gnu.java.lang.reflect.ClassSignatureParser;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Class<T>
implements Serializable,
Type,
AnnotatedElement,
GenericDeclaration {
    private static final long serialVersionUID = 3206093459760846163L;
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private Object[] signers = null;
    private final transient ProtectionDomain pd;
    final transient Object vmdata;
    private transient Constructor<T> constructor;

    Class(Object object) {
        this(object, null);
    }

    Class(Object object, ProtectionDomain protectionDomain) {
        this.vmdata = object;
        this.pd = protectionDomain == null && this.isArray() ? this.getComponentType().pd : protectionDomain;
    }

    public static Class<?> forName(String string) throws ClassNotFoundException {
        return VMClass.forName(string, true, VMStackWalker.getCallingClassLoader());
    }

    public static Class<?> forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2;
        SecurityManager securityManager;
        if (classLoader == null && (securityManager = SecurityManager.current) != null && (classLoader2 = VMStackWalker.getCallingClassLoader()) != null) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return VMClass.forName(string, bl, classLoader);
    }

    public Class<?>[] getClasses() {
        this.memberAccessCheck(0);
        return this.internalGetClasses();
    }

    private Class<?>[] internalGetClasses() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Arrays.asList(this.getDeclaredClasses(true)));
        Class<T> clazz = this.getSuperclass();
        if (clazz != null) {
            arrayList.addAll(Arrays.asList(super.internalGetClasses()));
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.isPrimitive()) {
            return null;
        }
        ClassLoader classLoader2 = VMClass.getClassLoader(this);
        SecurityManager securityManager = SecurityManager.current;
        if (classLoader2 != null && securityManager != null && (classLoader = VMStackWalker.getCallingClassLoader()) != null && !classLoader.isAncestorOf(classLoader2)) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return classLoader2;
    }

    public Class<?> getComponentType() {
        return VMClass.getComponentType(this);
    }

    public Constructor<T> getConstructor(Class<?> ... classArray) throws NoSuchMethodException {
        this.memberAccessCheck(0);
        Constructor<?>[] constructorArray = this.getDeclaredConstructors(true);
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            if (!Class.matchParameters(classArray, constructor.getParameterTypes())) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    public Constructor<?>[] getConstructors() {
        this.memberAccessCheck(0);
        return this.getDeclaredConstructors(true);
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... classArray) throws NoSuchMethodException {
        this.memberAccessCheck(1);
        Constructor<?>[] constructorArray = this.getDeclaredConstructors(false);
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            if (!Class.matchParameters(classArray, constructor.getParameterTypes())) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    public Class<?>[] getDeclaredClasses() {
        this.memberAccessCheck(1);
        return this.getDeclaredClasses(false);
    }

    Class<?>[] getDeclaredClasses(boolean bl) {
        return VMClass.getDeclaredClasses(this, bl);
    }

    public Constructor<?>[] getDeclaredConstructors() {
        this.memberAccessCheck(1);
        return this.getDeclaredConstructors(false);
    }

    Constructor<?>[] getDeclaredConstructors(boolean bl) {
        return VMClass.getDeclaredConstructors(this, bl);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.memberAccessCheck(1);
        Field[] fieldArray = this.getDeclaredFields(false);
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string)) continue;
            return fieldArray[i];
        }
        throw new NoSuchFieldException();
    }

    public Field[] getDeclaredFields() {
        this.memberAccessCheck(1);
        return this.getDeclaredFields(false);
    }

    Field[] getDeclaredFields(boolean bl) {
        return VMClass.getDeclaredFields(this, bl);
    }

    public Method getDeclaredMethod(String string, Class<?> ... classArray) throws NoSuchMethodException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.memberAccessCheck(1);
        Method method = Class.matchMethod(this.getDeclaredMethods(false), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method;
    }

    public Method[] getDeclaredMethods() {
        this.memberAccessCheck(1);
        return this.getDeclaredMethods(false);
    }

    Method[] getDeclaredMethods(boolean bl) {
        return VMClass.getDeclaredMethods(this, bl);
    }

    public Class<?> getDeclaringClass() {
        return VMClass.getDeclaringClass(this);
    }

    public Field getField(String string) throws NoSuchFieldException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.memberAccessCheck(0);
        Field field = this.internalGetField(string);
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        return field;
    }

    public Field[] getFields() {
        this.memberAccessCheck(0);
        return this.internalGetFields();
    }

    private Field[] internalGetFields() {
        LinkedHashSet<Field> linkedHashSet = new LinkedHashSet<Field>();
        linkedHashSet.addAll(Arrays.asList(this.getDeclaredFields(true)));
        Class<?>[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(super.internalGetFields()));
        }
        Class<T> clazz = this.getSuperclass();
        if (clazz != null) {
            linkedHashSet.addAll(Arrays.asList(super.internalGetFields()));
        }
        return linkedHashSet.toArray(new Field[linkedHashSet.size()]);
    }

    public Package getPackage() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            return classLoader.getPackage(Class.getPackagePortion(this.getName()));
        }
        return VMClassLoader.getPackage(Class.getPackagePortion(this.getName()));
    }

    public Class<?>[] getInterfaces() {
        return VMClass.getInterfaces(this);
    }

    public Method getMethod(String string, Class<?> ... classArray) throws NoSuchMethodException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.memberAccessCheck(0);
        Method method = this.internalGetMethod(string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method;
    }

    private Method internalGetMethod(String string, Class[] classArray) {
        Method method = Class.matchMethod(this.getDeclaredMethods(true), string, classArray);
        if (method != null) {
            return method;
        }
        Class<T> clazz = this.getSuperclass();
        if (clazz != null && (method = super.internalGetMethod(string, classArray)) != null) {
            return method;
        }
        Class<?>[] classArray2 = this.getInterfaces();
        for (int i = 0; i < classArray2.length; ++i) {
            method = super.internalGetMethod(string, classArray);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method matchMethod(Method[] methodArray, String string, Class[] classArray) {
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!method2.getName().equals(string) || !Class.matchParameters(classArray, method2.getParameterTypes()) || method != null && !method.getReturnType().isAssignableFrom(method2.getReturnType())) continue;
            method = method2;
        }
        return method;
    }

    private static boolean matchParameters(Class[] classArray, Class[] classArray2) {
        if (classArray == null) {
            return classArray2 == null || classArray2.length == 0;
        }
        if (classArray2 == null) {
            return classArray == null || classArray.length == 0;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == classArray2[i]) continue;
            return false;
        }
        return true;
    }

    public Method[] getMethods() {
        this.memberAccessCheck(0);
        return this.internalGetMethods();
    }

    private Method[] internalGetMethods() {
        int n;
        Method[] methodArray;
        HashMap<MethodKey, Method> hashMap = new HashMap<MethodKey, Method>();
        Class<?>[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            methodArray = super.internalGetMethods();
            for (n = 0; n < methodArray.length; ++n) {
                hashMap.put(new MethodKey(methodArray[n]), methodArray[n]);
            }
        }
        Class<T> clazz = this.getSuperclass();
        if (clazz != null) {
            methodArray = super.internalGetMethods();
            for (n = 0; n < methodArray.length; ++n) {
                hashMap.put(new MethodKey(methodArray[n]), methodArray[n]);
            }
        }
        methodArray = this.getDeclaredMethods(true);
        for (n = 0; n < methodArray.length; ++n) {
            hashMap.put(new MethodKey(methodArray[n]), methodArray[n]);
        }
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    public int getModifiers() {
        int n = VMClass.getModifiers(this, false);
        return n & 0x61F;
    }

    public String getName() {
        return VMClass.getName(this);
    }

    public URL getResource(String string) {
        String string2 = this.resourcePath(string);
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string2);
        }
        return classLoader.getResource(string2);
    }

    public InputStream getResourceAsStream(String string) {
        String string2 = this.resourcePath(string);
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return classLoader.getResourceAsStream(string2);
    }

    private String resourcePath(String string) {
        if (string.length() > 0) {
            if (string.charAt(0) != '/') {
                String string2 = Class.getPackagePortion(this.getName());
                if (string2.length() > 0) {
                    string = string2.replace('.', '/') + '/' + string;
                }
            } else {
                string = string.substring(1);
            }
        }
        return string;
    }

    public Object[] getSigners() {
        return this.signers == null ? null : (Object[])this.signers.clone();
    }

    void setSigners(Object[] objectArray) {
        this.signers = objectArray;
    }

    public Class<? super T> getSuperclass() {
        return VMClass.getSuperclass(this);
    }

    public boolean isArray() {
        return VMClass.isArray(this);
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        return VMClass.isAssignableFrom(this, clazz);
    }

    public boolean isInstance(Object object) {
        return VMClass.isInstance(this, object);
    }

    public boolean isInterface() {
        return VMClass.isInterface(this);
    }

    public boolean isPrimitive() {
        return VMClass.isPrimitive(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public T newInstance() throws InstantiationException, IllegalAccessException {
        int n;
        Constructor<?>[] constructorArray;
        this.memberAccessCheck(0);
        Constructor<?>[] constructorArray2 = this;
        // MONITORENTER : this
        Constructor<Object> constructor = this.constructor;
        // MONITOREXIT : constructorArray2
        if (constructor == null) {
            constructorArray2 = this.getDeclaredConstructors(false);
            for (int i = 0; i < constructorArray2.length; ++i) {
                if (constructorArray2[i].getParameterTypes().length != 0) continue;
                constructor = constructorArray2[i];
                break;
            }
            if (constructor == null) {
                throw new InstantiationException(this.getName());
            }
            if (!Modifier.isPublic(constructor.getModifiers()) || !Modifier.isPublic(VMClass.getModifiers(this, true))) {
                Class.setAccessible(constructor);
            }
            constructorArray = this;
            // MONITORENTER : this
            if (this.constructor == null) {
                this.constructor = constructor;
            }
            // MONITOREXIT : constructorArray
        }
        if (!(Modifier.isPublic(n = constructor.getModifiers()) && Modifier.isPublic(VMClass.getModifiers(this, true)) || (constructorArray = VMStackWalker.getCallingClass()) == null || constructorArray == this)) {
            if (Modifier.isPrivate(n)) throw new IllegalAccessException(this.getName() + " has an inaccessible constructor");
            if (this.getClassLoader() != constructorArray.getClassLoader()) throw new IllegalAccessException(this.getName() + " has an inaccessible constructor");
            if (!Class.getPackagePortion(this.getName()).equals(Class.getPackagePortion(constructorArray.getName()))) {
                throw new IllegalAccessException(this.getName() + " has an inaccessible constructor");
            }
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            VMClass.throwException(invocationTargetException.getTargetException());
            throw (InternalError)new InternalError("VMClass.throwException returned").initCause(invocationTargetException);
        }
    }

    public ProtectionDomain getProtectionDomain() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getProtectionDomain"));
        }
        return this.pd == null ? StaticData.unknownProtectionDomain : this.pd;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        Object object;
        Object object2;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return VMClassLoader.defaultAssertionStatus();
        }
        if (classLoader.classAssertionStatus != null) {
            object2 = classLoader;
            synchronized (object2) {
                object = classLoader.classAssertionStatus.get(this.getName());
                if (object != null) {
                    return object.equals(Boolean.TRUE);
                }
            }
        } else {
            object = ClassLoader.StaticData.systemClassAssertionStatus.get(this.getName());
            if (object != null) {
                return object.equals(Boolean.TRUE);
            }
        }
        if (classLoader.packageAssertionStatus != null) {
            object2 = classLoader;
            synchronized (object2) {
                String string = Class.getPackagePortion(this.getName());
                if ("".equals(string)) {
                    object = classLoader.packageAssertionStatus.get(null);
                } else {
                    do {
                        object = classLoader.packageAssertionStatus.get(string);
                    } while (!"".equals(string = Class.getPackagePortion(string)) && object == null);
                }
                if (object != null) {
                    return object.equals(Boolean.TRUE);
                }
            }
        } else {
            object2 = Class.getPackagePortion(this.getName());
            if ("".equals(object2)) {
                object = ClassLoader.StaticData.systemPackageAssertionStatus.get(null);
            } else {
                do {
                    object = ClassLoader.StaticData.systemPackageAssertionStatus.get(object2);
                } while (!"".equals(object2 = Class.getPackagePortion((String)object2)) && object == null);
            }
            if (object != null) {
                return object.equals(Boolean.TRUE);
            }
        }
        return classLoader.defaultAssertionStatus;
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new ClassCastException();
        }
        return this;
    }

    public T cast(Object object) {
        if (object != null && !this.isInstance(object)) {
            throw new ClassCastException();
        }
        return (T)object;
    }

    private Field internalGetField(String string) {
        Field[] fieldArray = this.getDeclaredFields(true);
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!field.getName().equals(string)) continue;
            return field;
        }
        Class<?>[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Field field = super.internalGetField(string);
            if (field == null) continue;
            return field;
        }
        Class<T> clazz = this.getSuperclass();
        if (clazz != null) {
            return super.internalGetField(string);
        }
        return null;
    }

    private static String getPackagePortion(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private void memberAccessCheck(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, n);
            Package package_ = this.getPackage();
            if (package_ != null) {
                securityManager.checkPackageAccess(package_.getName());
            }
        }
    }

    public T[] getEnumConstants() {
        if (this.isEnum()) {
            try {
                Method method = this.getMethod("values", new Class[0]);
                Class.setAccessible(method);
                return (Object[])method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error("Enum lacks values() method");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Unable to access Enum class");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("The values method threw an exception", invocationTargetException);
            }
        }
        return null;
    }

    public boolean isEnum() {
        int n = VMClass.getModifiers(this, true);
        return (n & 0x4000) != 0;
    }

    public boolean isSynthetic() {
        int n = VMClass.getModifiers(this, true);
        return (n & 0x1000) != 0;
    }

    public boolean isAnnotation() {
        int n = VMClass.getModifiers(this, true);
        return (n & 0x2000) != 0;
    }

    public String getSimpleName() {
        return VMClass.getSimpleName(this);
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Annotation[] annotationArray;
        Annotation annotation = null;
        for (Annotation annotation2 : annotationArray = this.getAnnotations()) {
            if (annotation2.annotationType() != clazz) continue;
            annotation = annotation2;
        }
        return (A)annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        HashMap<Class<? extends Annotation>, Annotation> hashMap = new HashMap<Class<? extends Annotation>, Annotation>();
        Object object = this.getDeclaredAnnotations();
        int n = ((Annotation[])object).length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation = object[i];
            hashMap.put(annotation.annotationType(), annotation);
        }
        for (object = this.getSuperclass(); object != null; object = ((Class)object).getSuperclass()) {
            for (Annotation annotation : ((Class)object).getDeclaredAnnotations()) {
                Class<? extends Annotation> clazz = annotation.annotationType();
                if (hashMap.containsKey(clazz) || !clazz.isAnnotationPresent(Inherited.class)) continue;
                hashMap.put(clazz, annotation);
            }
        }
        object = hashMap.values();
        return object.toArray(new Annotation[object.size()]);
    }

    public String getCanonicalName() {
        return VMClass.getCanonicalName(this);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return VMClass.getDeclaredAnnotations(this);
    }

    public Class<?> getEnclosingClass() {
        return VMClass.getEnclosingClass(this);
    }

    public Constructor<?> getEnclosingConstructor() {
        return VMClass.getEnclosingConstructor(this);
    }

    public Method getEnclosingMethod() {
        return VMClass.getEnclosingMethod(this);
    }

    public Type[] getGenericInterfaces() {
        if (this.isPrimitive()) {
            return new Type[0];
        }
        String string = VMClass.getClassSignature(this);
        if (string == null) {
            return this.getInterfaces();
        }
        ClassSignatureParser classSignatureParser = new ClassSignatureParser(this, string);
        return classSignatureParser.getInterfaceTypes();
    }

    public Type getGenericSuperclass() {
        if (this.isArray()) {
            return Object.class;
        }
        if (this.isPrimitive() || this.isInterface() || this == Object.class) {
            return null;
        }
        String string = VMClass.getClassSignature(this);
        if (string == null) {
            return this.getSuperclass();
        }
        ClassSignatureParser classSignatureParser = new ClassSignatureParser(this, string);
        return classSignatureParser.getSuperclassType();
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        String string = VMClass.getClassSignature(this);
        if (string == null) {
            return new TypeVariable[0];
        }
        ClassSignatureParser classSignatureParser = new ClassSignatureParser(this, string);
        return classSignatureParser.getTypeParameters();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation((Class)clazz) != null;
    }

    public boolean isAnonymousClass() {
        return VMClass.isAnonymousClass(this);
    }

    public boolean isLocalClass() {
        return VMClass.isLocalClass(this);
    }

    public boolean isMemberClass() {
        return VMClass.isMemberClass(this);
    }

    static void setAccessible(final AccessibleObject accessibleObject) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                accessibleObject.setAccessible(true);
                return null;
            }
        });
    }

    private static final class MethodKey {
        private String name;
        private Class[] params;
        private Class returnType;
        private int hash;

        MethodKey(Method method) {
            this.name = method.getName();
            this.params = method.getParameterTypes();
            this.returnType = method.getReturnType();
            this.hash = this.name.hashCode() ^ this.returnType.hashCode();
            for (int i = 0; i < this.params.length; ++i) {
                this.hash ^= this.params[i].hashCode();
            }
        }

        public boolean equals(Object object) {
            if (object instanceof MethodKey) {
                MethodKey methodKey = (MethodKey)object;
                if (methodKey.name.equals(this.name) && methodKey.params.length == this.params.length && methodKey.returnType == this.returnType) {
                    for (int i = 0; i < this.params.length; ++i) {
                        if (methodKey.params[i] == this.params[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class StaticData {
        static final ProtectionDomain unknownProtectionDomain;

        private StaticData() {
        }

        static {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            unknownProtectionDomain = new ProtectionDomain(null, permissions);
        }
    }
}

