/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

abstract class AbstractStringBuffer
implements Serializable,
CharSequence,
Appendable {
    int count;
    char[] value;
    private static final int DEFAULT_CAPACITY = 16;

    AbstractStringBuffer() {
        this(16);
    }

    AbstractStringBuffer(int n) {
        this.value = new char[n];
    }

    AbstractStringBuffer(String string) {
        this.count = string.count;
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    AbstractStringBuffer(CharSequence charSequence) {
        int n = charSequence.length();
        this.count = n <= 0 ? 0 : n;
        this.value = new char[this.count + 16];
        for (int i = 0; i < n; ++i) {
            this.value[i] = charSequence.charAt(i);
        }
    }

    public void ensureCapacity(int n) {
        this.ensureCapacity_unsynchronized(n);
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = this.value.length;
        this.ensureCapacity_unsynchronized(n);
        if (n < n2) {
            this.count = n;
        } else {
            while (this.count < n) {
                this.value[this.count++] = '\u0000';
            }
        }
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public int codePointAt(int n) {
        return Character.codePointAt(this.value, n, this.count);
    }

    public int codePointBefore(int n) {
        if (n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBefore(this.value, n, 1);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n2 > this.count || n2 < n) {
            throw new StringIndexOutOfBoundsException();
        }
        VMSystem.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[n] = c;
    }

    public AbstractStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public AbstractStringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = string.count;
        this.ensureCapacity_unsynchronized(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractStringBuffer append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n = stringBuffer.count;
            this.ensureCapacity(this.count + n);
            VMSystem.arraycopy(stringBuffer.value, 0, this.value, this.count, n);
            this.count += n;
        }
        return this;
    }

    public AbstractStringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public AbstractStringBuffer append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + n2);
        VMSystem.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public AbstractStringBuffer append(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public AbstractStringBuffer append(char c) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public AbstractStringBuffer append(CharSequence charSequence) {
        return this.append(charSequence, 0, charSequence.length());
    }

    public AbstractStringBuffer append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n2 - n > 0) {
            this.ensureCapacity_unsynchronized(this.count + n2 - n);
            while (n < n2) {
                this.value[this.count++] = charSequence.charAt(n);
                ++n;
            }
        }
        return this;
    }

    public AbstractStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public AbstractStringBuffer append(long l) {
        return this.append(Long.toString(l, 10));
    }

    public AbstractStringBuffer append(float f) {
        return this.append(Float.toString(f));
    }

    public AbstractStringBuffer append(double d) {
        return this.append(Double.toString(d));
    }

    public AbstractStringBuffer appendCodePoint(int n) {
        int n2 = Character.charCount(n);
        this.ensureCapacity_unsynchronized(this.count + n2);
        Character.toChars(n, this.value, this.count);
        this.count += n2;
        return this;
    }

    public AbstractStringBuffer delete(int n, int n2) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - n2 != 0) {
            VMSystem.arraycopy(this.value, n2, this.value, n, this.count - n2);
        }
        this.count -= n2 - n;
        return this;
    }

    public AbstractStringBuffer deleteCharAt(int n) {
        return this.delete(n, n + 1);
    }

    public AbstractStringBuffer replace(int n, int n2, String string) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n3 = string.count;
        int n4 = n3 - (n2 > this.count ? this.count : n2) + n;
        this.ensureCapacity_unsynchronized(this.count + n4);
        if (n4 != 0 && n2 < this.count) {
            VMSystem.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        }
        string.getChars(0, n3, this.value, n);
        this.count += n4;
        return this;
    }

    public AbstractStringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count || n3 < 0 || n2 < 0 || n2 > cArray.length - n3) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + n3);
        VMSystem.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        VMSystem.arraycopy(cArray, n2, this.value, n, n3);
        this.count += n3;
        return this;
    }

    public AbstractStringBuffer insert(int n, Object object) {
        return this.insert(n, object == null ? "null" : object.toString());
    }

    public AbstractStringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.count;
        this.ensureCapacity_unsynchronized(this.count + n2);
        VMSystem.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public AbstractStringBuffer insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public AbstractStringBuffer insert(int n, CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n2 < 0 || n3 < 0 || n2 > n3 || n3 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        this.ensureCapacity_unsynchronized(this.count + n4);
        VMSystem.arraycopy(this.value, n, this.value, n + n4, this.count - n);
        for (int i = n2; i < n3; ++i) {
            this.value[n++] = charSequence.charAt(i);
        }
        this.count += n4;
        return this;
    }

    public AbstractStringBuffer insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public AbstractStringBuffer insert(int n, boolean bl) {
        return this.insert(n, bl ? "true" : "false");
    }

    public AbstractStringBuffer insert(int n, char c) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        VMSystem.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public AbstractStringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public AbstractStringBuffer insert(int n, long l) {
        return this.insert(n, Long.toString(l, 10));
    }

    public AbstractStringBuffer insert(int n, float f) {
        return this.insert(n, Float.toString(f));
    }

    public AbstractStringBuffer insert(int n, double d) {
        return this.insert(n, Double.toString(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.count - string.count;
        while (n <= n2) {
            if (this.regionMatches(n, string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count - string.count);
    }

    public int lastIndexOf(String string, int n) {
        for (n = Math.min(n, this.count - string.count); n >= 0; --n) {
            if (!this.regionMatches(n, string)) continue;
            return n;
        }
        return -1;
    }

    public AbstractStringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        int n = this.count >> 1;
        int n2 = this.count - n;
        while (--n >= 0) {
            char c = this.value[n];
            this.value[n] = this.value[n2];
            this.value[n2] = c;
            ++n2;
        }
        return this;
    }

    public void trimToSize() {
        int n = this.value.length - this.count;
        if (n < 20) {
            return;
        }
        if (n > 200 || n * 4 > this.value.length) {
            char[] cArray = new char[this.count];
            VMSystem.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 >= this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n < n2) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != n2 && n != n3 && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            ++n3;
        }
        return n3;
    }

    public int offsetByCodePoints(int n, int n2) {
        while (n2 > 0) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != this.count && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            --n2;
        }
        return n;
    }

    void ensureCapacity_unsynchronized(int n) {
        if (n > this.value.length) {
            int n2 = this.value.length * 2 + 2;
            n = n < n2 ? n2 : n;
            char[] cArray = new char[n];
            VMSystem.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    private boolean regionMatches(int n, String string) {
        int n2 = string.count;
        int n3 = string.offset;
        while (--n2 >= 0) {
            if (this.value[n++] == string.value[n3++]) continue;
            return false;
        }
        return true;
    }
}

