/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.PlatformHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

final class VMFile {
    static final boolean IS_CASE_SENSITIVE = true;
    static final boolean IS_DOS_8_3 = false;

    private VMFile() {
    }

    static native long lastModified(String var0);

    static native boolean setReadOnly(String var0);

    static native boolean create(String var0) throws IOException;

    static synchronized native String[] list(String var0);

    static native boolean renameTo(String var0, String var1);

    static native long length(String var0);

    static native boolean exists(String var0);

    static native boolean delete(String var0);

    static native boolean setLastModified(String var0, long var1);

    static native boolean mkdir(String var0);

    static native long getTotalSpace(String var0);

    static native long getFreeSpace(String var0);

    static native long getUsableSpace(String var0);

    static synchronized native boolean setReadable(String var0, boolean var1, boolean var2);

    static synchronized native boolean setWritable(String var0, boolean var1, boolean var2);

    static synchronized native boolean setExecutable(String var0, boolean var1, boolean var2);

    static native boolean isFile(String var0);

    static synchronized native boolean canWrite(String var0);

    static native boolean canWriteDirectory(String var0);

    static synchronized native boolean canRead(String var0);

    static synchronized native boolean canExecute(String var0);

    static native boolean isDirectory(String var0);

    static boolean canWriteDirectory(File file) {
        return VMFile.canWriteDirectory(file.getAbsolutePath());
    }

    static File[] listRoots() {
        File[] fileArray = new File[]{new File("/")};
        return fileArray;
    }

    static boolean isHidden(String string) {
        return VMFile.getName(string).startsWith(".");
    }

    static String getName(String string) {
        int n = PlatformHelper.lastIndexOfSeparator(string);
        if (n == -1) {
            return string;
        }
        if (PlatformHelper.endWithSeparator(string)) {
            return "";
        }
        return string.substring(n + File.separator.length());
    }

    static String getAbsolutePath(String string) {
        if (File.separatorChar == '\\' && string.length() > 0 && string.charAt(0) == '\\') {
            return System.getProperty("user.dir").substring(0, 2) + string;
        }
        if (File.separatorChar == '\\' && string.length() > 1 && string.charAt(1) == ':' && (string.charAt(0) >= 'a' && string.charAt(0) <= 'z' || string.charAt(0) >= 'A' && string.charAt(0) <= 'Z')) {
            String string2 = null;
            try {
                string2 = new File(string.substring(0, 2)).getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = string.substring(0, 2) + "\\";
            }
            if (string.length() > 2) {
                return string2 + '\\' + string.substring(2, string.length());
            }
            return string2;
        }
        if (string.equals("")) {
            return System.getProperty("user.dir");
        }
        return System.getProperty("user.dir") + File.separatorChar + string;
    }

    static boolean isAbsolute(String string) {
        if (File.separatorChar == '\\') {
            return string.startsWith(File.separator + File.separator) || string.length() > 2 && (string.charAt(0) >= 'a' && string.charAt(0) <= 'z' || string.charAt(0) >= 'A' && string.charAt(0) <= 'Z') && string.charAt(1) == ':' && string.charAt(2) == '\\';
        }
        return string.startsWith(File.separator);
    }

    static URL toURL(File file) throws MalformedURLException {
        if (File.separatorChar == '\\') {
            return new URL("file:/" + file.getAbsolutePath().replace('\\', '/') + (file.isDirectory() ? "/" : ""));
        }
        return new URL("file:" + file.getAbsolutePath() + (file.isDirectory() ? "/" : ""));
    }

    static native String toCanonicalForm(String var0) throws IOException;

    static {
        System.loadLibrary("javaio");
    }
}

