/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private static final int DEFAULT_BUFFER_SIZE = 1;
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    public PushbackReader(Reader reader, int n) {
        super(reader);
        if (n < 0) {
            throw new IllegalArgumentException("buffer size must be positive");
        }
        this.buf = new char[n];
        this.pos = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            super.close();
        }
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark not supported in this class");
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported in this class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            return this.buf.length - this.pos > 0 || super.ready();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (l <= 0L) {
                return 0L;
            }
            if ((long)(this.buf.length - this.pos) >= l) {
                this.pos = (int)((long)this.pos + l);
                return l;
            }
            int n = this.buf.length - this.pos;
            this.pos = this.buf.length;
            long l2 = this.in.skip(l - (long)n);
            return (long)n + l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (this.pos == this.buf.length) {
                return super.read();
            }
            ++this.pos;
            return this.buf[this.pos - 1] & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n3 = Math.min(this.buf.length - this.pos, n2);
            if (n3 > 0) {
                System.arraycopy(this.buf, this.pos, cArray, n, n3);
                this.pos += n3;
                return n3;
            }
            return super.read(cArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (this.pos == 0) {
                throw new IOException("Pushback buffer is full");
            }
            --this.pos;
            this.buf[this.pos] = (char)(n & 0xFFFF);
        }
    }

    public synchronized void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (this.pos < n2) {
                throw new IOException("Pushback buffer is full");
            }
            System.arraycopy(cArray, n, this.buf, this.pos - n2, n2);
            this.pos -= n2;
        }
    }
}

