/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1;
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public PushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
        this.pos = this.buf.length;
    }

    public int available() throws IOException {
        try {
            return this.buf.length - this.pos + super.available();
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized void close() throws IOException {
        this.buf = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("Mark not supported in this class");
    }

    public synchronized int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(this.buf.length - this.pos, n2);
        if (n3 > 0) {
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos += n3;
            n2 -= n3;
            n += n3;
        }
        if (n2 > 0) {
            if ((n2 = super.read(byArray, n, n2)) == -1) {
                return n3 > 0 ? n3 : -1;
            }
            n3 += n2;
        }
        return n3;
    }

    public synchronized void unread(int n) throws IOException {
        if (this.pos <= 0) {
            throw new IOException("Insufficient space in pushback buffer");
        }
        this.buf[--this.pos] = (byte)n;
    }

    public synchronized void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public synchronized void unread(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos < n2) {
            throw new IOException("Insufficient space in pushback buffer");
        }
        System.arraycopy(byArray, n, this.buf, this.pos - n2, n2);
        this.pos -= n2;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = l;
        if (l > 0L) {
            int n = (int)Math.min((long)(this.buf.length - this.pos), l);
            this.pos += n;
            if ((l -= (long)n) > 0L) {
                l -= super.skip(l);
            }
        }
        return l2 - l;
    }
}

