/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    PipedReader sink;
    boolean closed;
    char[] read_buf = new char[1];

    public PipedWriter() {
    }

    public PipedWriter(PipedReader pipedReader) throws IOException {
        pipedReader.connect(this);
    }

    public void connect(PipedReader pipedReader) throws IOException {
        if (this.sink != null || pipedReader.source != null) {
            throw new IOException("Already connected");
        }
        pipedReader.connect(this);
    }

    public void write(int n) throws IOException {
        this.read_buf[0] = (char)(n & 0xFFFF);
        this.sink.receive(this.read_buf, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(cArray, n, n2);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.sink != null) {
            this.closed = true;
            PipedReader pipedReader = this.sink;
            synchronized (pipedReader) {
                this.sink.notifyAll();
            }
        }
    }
}

