/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.Pair;
import gnu.classpath.VMStackWalker;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.VMObjectInputStream;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Map<Integer, Pair<Boolean, Object>> handles;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private TreeSet<ValidatorAndPriority> currentObjectValidators;
    private boolean readDataFromBlock;
    private boolean fieldsAlreadyRead;
    private Hashtable<Class, ObjectStreamClass> classLookupTable;
    private GetField prereadFields;
    private static boolean dump;
    private int depth = 0;
    private static final boolean DEBUG = false;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.resolveEnabled = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(inputStream);
        this.nextOID = 0x7E0000;
        this.handles = new HashMap<Integer, Pair<Boolean, Object>>();
        this.classLookupTable = new Hashtable();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    @Override
    public final Object readObject() throws ClassNotFoundException, IOException {
        return this.readObject(true);
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object readObject(boolean bl) throws ClassNotFoundException, IOException {
        Object object;
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean bl2 = this.setBlockDataMode(false);
        byte by = this.realInputStream.readByte();
        if (dump) {
            this.dumpElement("MARKER: 0x" + Integer.toHexString(by) + " ");
        }
        try {
            object = this.parseContent(by, bl);
            Object var6_5 = null;
            this.setBlockDataMode(bl2);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setBlockDataMode(bl2);
            throw throwable;
        }
        return object;
    }

    private Object parseContent(byte by, boolean bl) throws ClassNotFoundException, IOException {
        Object object;
        boolean bl2 = false;
        switch (by) {
            case 120: {
                object = null;
                bl2 = true;
                break;
            }
            case 119: 
            case 122: {
                if (by == 122) {
                    if (dump) {
                        this.dumpElementln("BLOCKDATALONG");
                    }
                } else if (dump) {
                    this.dumpElementln("BLOCKDATA");
                }
                this.readNextBlock(by);
            }
            case 112: {
                if (dump) {
                    this.dumpElementln("NULL");
                }
                object = null;
                break;
            }
            case 113: {
                if (dump) {
                    this.dumpElement("REFERENCE ");
                }
                int n = this.realInputStream.readInt();
                if (dump) {
                    this.dumpElementln(Integer.toHexString(n));
                }
                object = this.lookupHandle(n);
                if (bl) break;
                throw new InvalidObjectException("References can not be read unshared.");
            }
            case 118: {
                if (dump) {
                    this.dumpElementln("CLASS");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class<?> clazz = objectStreamClass.forClass();
                this.assignNewHandle(clazz, bl);
                object = clazz;
                break;
            }
            case 125: {
                int n;
                if (dump) {
                    this.dumpElementln("PROXYCLASS");
                }
                int n2 = this.realInputStream.readInt();
                String[] stringArray = new String[n2];
                for (n = 0; n < n2; n += 1) {
                    stringArray[n] = this.realInputStream.readUTF();
                }
                n = this.setBlockDataMode(true) ? 1 : 0;
                Class<?> clazz = this.resolveProxyClass(stringArray);
                this.setBlockDataMode(n != 0);
                ObjectStreamClass objectStreamClass = this.lookupClass(clazz);
                if (objectStreamClass.firstNonSerializableParentConstructor == null) {
                    objectStreamClass.realClassIsSerializable = true;
                    objectStreamClass.fieldMapping = new ObjectStreamField[0];
                    objectStreamClass.fields = objectStreamClass.fieldMapping;
                    try {
                        objectStreamClass.firstNonSerializableParentConstructor = Object.class.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw (InternalError)new InternalError("Object ctor missing").initCause(noSuchMethodException);
                    }
                }
                this.assignNewHandle(objectStreamClass, bl);
                if (!bl2) {
                    byte by2 = this.realInputStream.readByte();
                    if (by2 != 120) {
                        throw new IOException("Data annotated to class was not consumed." + by2);
                    }
                } else {
                    bl2 = false;
                }
                ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
                objectStreamClass.setSuperclass(objectStreamClass2);
                object = objectStreamClass;
                break;
            }
            case 114: {
                ObjectStreamClass objectStreamClass = this.readClassDescriptor();
                if (!bl2) {
                    byte by3 = this.realInputStream.readByte();
                    if (by3 != 120) {
                        throw new IOException("Data annotated to class was not consumed." + by3);
                    }
                } else {
                    bl2 = false;
                }
                objectStreamClass.setSuperclass((ObjectStreamClass)this.readObject());
                object = objectStreamClass;
                break;
            }
            case 116: {
                if (dump) {
                    this.dumpElement("STRING=");
                }
                String string = this.realInputStream.readUTF();
                if (dump) {
                    this.dumpElementln(string);
                }
                object = this.processResolution(null, string, this.assignNewHandle(string, bl), bl);
                break;
            }
            case 124: {
                if (dump) {
                    this.dumpElement("STRING=");
                }
                String string = this.realInputStream.readUTFLong();
                if (dump) {
                    this.dumpElementln(string);
                }
                object = this.processResolution(null, string, this.assignNewHandle(string, bl), bl);
                break;
            }
            case 117: {
                if (dump) {
                    this.dumpElementln("ARRAY");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class<?> clazz = objectStreamClass.forClass().getComponentType();
                if (dump) {
                    this.dumpElement("ARRAY LENGTH=");
                }
                int n = this.realInputStream.readInt();
                if (dump) {
                    this.dumpElementln(n + "; COMPONENT TYPE=" + clazz);
                }
                Object object2 = Array.newInstance(clazz, n);
                int n3 = this.assignNewHandle(object2, bl);
                this.readArrayElements(object2, clazz);
                if (dump) {
                    int n4 = Array.getLength(object2);
                    for (int i = 0; i < n4; ++i) {
                        this.dumpElementln("  ELEMENT[" + i + "]=", Array.get(object2, i));
                    }
                }
                object = this.processResolution(null, object2, n3, bl);
                break;
            }
            case 115: {
                if (dump) {
                    this.dumpElementln("OBJECT");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class<?> clazz = objectStreamClass.forClass();
                if (!objectStreamClass.realClassIsSerializable) {
                    throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                }
                if (objectStreamClass.realClassIsExternalizable) {
                    Externalizable externalizable = objectStreamClass.newInstance();
                    int n = this.assignNewHandle(externalizable, bl);
                    boolean bl3 = (objectStreamClass.getFlags() & 8) != 0;
                    boolean bl4 = this.readDataFromBlock;
                    if (bl3) {
                        this.setBlockDataMode(true);
                    }
                    externalizable.readExternal(this);
                    if (bl3) {
                        this.setBlockDataMode(bl4);
                        if (!bl4 && this.realInputStream.readByte() != 120) {
                            throw new IOException("No end of block data seen for class with readExternal (ObjectInputStream) method.");
                        }
                    }
                    object = this.processResolution(objectStreamClass, externalizable, n, bl);
                    break;
                }
                Object object3 = this.newObject(clazz, objectStreamClass.firstNonSerializableParentConstructor);
                int n = this.assignNewHandle(object3, bl);
                Object object4 = this.currentObject;
                ObjectStreamClass objectStreamClass3 = this.currentObjectStreamClass;
                TreeSet<ValidatorAndPriority> treeSet = this.currentObjectValidators;
                this.currentObject = object3;
                this.currentObjectValidators = null;
                ObjectStreamClass[] objectStreamClassArray = this.hierarchy(clazz);
                for (int i = 0; i < objectStreamClassArray.length; ++i) {
                    int by4;
                    Method method;
                    this.currentObjectStreamClass = objectStreamClassArray[i];
                    if (dump) {
                        this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                    }
                    if ((method = this.currentObjectStreamClass.readObjectMethod) != null) {
                        this.fieldsAlreadyRead = false;
                        by4 = this.setBlockDataMode(true);
                        this.callReadMethod(method, this.currentObjectStreamClass.forClass(), object3);
                        this.setBlockDataMode(by4 != 0);
                    } else {
                        this.readFields(object3, this.currentObjectStreamClass);
                    }
                    if (!this.currentObjectStreamClass.hasWriteMethod()) continue;
                    if (dump) {
                        this.dumpElement("ENDBLOCKDATA? ");
                    }
                    try {
                        by4 = this.realInputStream.readByte();
                        while (by4 != 120) {
                            this.parseContent((byte)by4, bl);
                            by4 = this.realInputStream.readByte();
                        }
                        if (!dump) continue;
                        this.dumpElementln("yes");
                        continue;
                    }
                    catch (EOFException eOFException) {
                        throw (IOException)new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.").initCause(eOFException);
                    }
                }
                this.currentObject = object4;
                this.currentObjectStreamClass = objectStreamClass3;
                object = this.processResolution(objectStreamClass, object3, n, bl);
                if (this.currentObjectValidators != null) {
                    this.invokeValidators();
                }
                this.currentObjectValidators = treeSet;
                break;
            }
            case 121: {
                if (dump) {
                    this.dumpElementln("RESET");
                }
                this.clearHandles();
                object = this.readObject();
                break;
            }
            case 123: {
                if (dump) {
                    this.dumpElement("EXCEPTION=");
                }
                Exception exception = (Exception)this.readObject();
                if (dump) {
                    this.dumpElementln(exception.toString());
                }
                this.clearHandles();
                throw new WriteAbortedException("Exception thrown during writing of stream", exception);
            }
            case 126: {
                if (dump) {
                    this.dumpElementln("ENUM=");
                }
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                String string = (String)this.readObject();
                if (dump) {
                    this.dumpElementln("CONSTANT NAME = " + string);
                }
                Class<?> clazz = objectStreamClass.forClass();
                Object obj = Enum.valueOf(clazz, string);
                this.assignNewHandle(obj, bl);
                object = obj;
                break;
            }
            default: {
                throw new IOException("Unknown marker on stream: " + by);
            }
        }
        return object;
    }

    private void checkTypeConsistency(String string, ObjectStreamField[] objectStreamFieldArray, ObjectStreamField[] objectStreamFieldArray2) throws InvalidClassException {
        int n = 0;
        for (n = 0; n < objectStreamFieldArray.length && objectStreamFieldArray[n].isPrimitive(); ++n) {
        }
        if (n == objectStreamFieldArray.length) {
            return;
        }
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length && n < objectStreamFieldArray.length) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[n];
            ObjectStreamField objectStreamField2 = objectStreamFieldArray2[n2];
            if (!objectStreamField2.isPrimitive()) break;
            int n3 = objectStreamField.getName().compareTo(objectStreamField2.getName());
            if (n3 < 0) {
                ++n;
                continue;
            }
            if (n3 > 0) {
                ++n2;
                continue;
            }
            throw new InvalidClassException("invalid field type for " + objectStreamField2.getName() + " in class " + string);
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws ClassNotFoundException, IOException {
        int n;
        Object object;
        if (dump) {
            this.dumpElement("CLASSDESC NAME=");
        }
        String string = this.realInputStream.readUTF();
        if (dump) {
            this.dumpElement(string + "; UID=");
        }
        long l = this.realInputStream.readLong();
        if (dump) {
            this.dumpElement(Long.toHexString(l) + "; FLAGS=");
        }
        byte by = this.realInputStream.readByte();
        if (dump) {
            this.dumpElement(Integer.toHexString(by) + "; FIELD COUNT=");
        }
        int n2 = this.realInputStream.readShort();
        if (dump) {
            this.dumpElementln(Short.toString((short)n2));
        }
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[n2];
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l, by, objectStreamFieldArray);
        this.assignNewHandle(objectStreamClass, true);
        for (int i = 0; i < n2; i += 1) {
            if (dump) {
                this.dumpElement("  TYPE CODE=");
            }
            char c = (char)this.realInputStream.readByte();
            if (dump) {
                this.dumpElement(c + "; FIELD NAME=");
            }
            String string2 = this.realInputStream.readUTF();
            if (dump) {
                this.dumpElementln(string2);
            }
            object = c == 'L' || c == '[' ? (String)this.readObject() : String.valueOf(c);
            objectStreamFieldArray[i] = new ObjectStreamField(string2, (String)object);
        }
        Class<?> clazz = this.resolveClass(objectStreamClass);
        ClassLoader classLoader = clazz.getClassLoader();
        for (n = 0; n < n2; n += 1) {
            objectStreamFieldArray[n].resolveType(classLoader);
        }
        n = this.setBlockDataMode(true) ? 1 : 0;
        objectStreamClass.setClass(clazz, this.lookupClass(clazz.getSuperclass()));
        this.classLookupTable.put(clazz, objectStreamClass);
        this.setBlockDataMode(n != 0);
        object = clazz.getSuperclass();
        if (object == null) {
            object = clazz;
        } else {
            while (Serializable.class.isAssignableFrom((Class<?>)object)) {
                object = ((Class)object).getSuperclass();
            }
        }
        final Class<?> clazz2 = object;
        objectStreamClass.firstNonSerializableParentConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Constructor constructor = clazz2.getDeclaredConstructor(new Class[0]);
                    if (Modifier.isPrivate(constructor.getModifiers())) {
                        return null;
                    }
                    return constructor;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        objectStreamClass.realClassIsSerializable = Serializable.class.isAssignableFrom(clazz);
        objectStreamClass.realClassIsExternalizable = Externalizable.class.isAssignableFrom(clazz);
        ObjectStreamField[] objectStreamFieldArray2 = objectStreamClass.fields;
        ObjectStreamField[] objectStreamFieldArray3 = ObjectStreamClass.lookupForClassObject(clazz).fields;
        ObjectStreamField[] objectStreamFieldArray4 = new ObjectStreamField[2 * Math.max(objectStreamFieldArray2.length, objectStreamFieldArray3.length)];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.checkTypeConsistency(string, objectStreamFieldArray3, objectStreamFieldArray2);
        this.checkTypeConsistency(string, objectStreamFieldArray2, objectStreamFieldArray3);
        while (n3 < objectStreamFieldArray2.length || n4 < objectStreamFieldArray3.length) {
            ObjectStreamField objectStreamField = null;
            ObjectStreamField objectStreamField2 = null;
            if (n3 == objectStreamFieldArray2.length) {
                objectStreamField2 = objectStreamFieldArray3[n4++];
            } else if (n4 == objectStreamFieldArray3.length) {
                objectStreamField = objectStreamFieldArray2[n3++];
            } else {
                int n6 = objectStreamFieldArray3[n4].compareTo(objectStreamFieldArray2[n3]);
                if (n6 < 0) {
                    objectStreamField2 = objectStreamFieldArray3[n4++];
                } else if (n6 > 0) {
                    objectStreamField = objectStreamFieldArray2[n3++];
                } else {
                    objectStreamField = objectStreamFieldArray2[n3++];
                    objectStreamField2 = objectStreamFieldArray3[n4++];
                    if (objectStreamField.getType() != objectStreamField2.getType()) {
                        throw new InvalidClassException("invalid field type for " + objectStreamField2.getName() + " in class " + string);
                    }
                }
            }
            if (n5 == objectStreamFieldArray4.length) {
                ObjectStreamField[] objectStreamFieldArray5 = new ObjectStreamField[objectStreamFieldArray4.length + 2];
                System.arraycopy(objectStreamFieldArray4, 0, objectStreamFieldArray5, 0, objectStreamFieldArray4.length);
                objectStreamFieldArray4 = objectStreamFieldArray5;
            }
            objectStreamFieldArray4[n5++] = objectStreamField;
            objectStreamFieldArray4[n5++] = objectStreamField2;
        }
        objectStreamClass.fieldMapping = objectStreamFieldArray4;
        return objectStreamClass;
    }

    public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        boolean bl = this.setBlockDataMode(false);
        this.readFields(this.currentObject, this.currentObjectStreamClass);
        this.setBlockDataMode(bl);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws InvalidObjectException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        if (this.currentObjectValidators == null) {
            this.currentObjectValidators = new TreeSet();
        }
        this.currentObjectValidators.add(new ValidatorAndPriority(objectInputValidation, n));
    }

    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        String string = objectStreamClass.getName();
        try {
            return Class.forName(string, true, this.currentLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals("void")) {
                return Void.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            throw classNotFoundException;
        }
    }

    private ClassLoader currentLoader() {
        return VMStackWalker.firstNonNullClassLoader();
    }

    private ObjectStreamClass lookupClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = this.classLookupTable.get(clazz);
        if (objectStreamClass == null) {
            return ObjectStreamClass.lookup(clazz);
        }
        return objectStreamClass;
    }

    private ObjectStreamClass[] hierarchy(Class clazz) {
        ObjectStreamClass objectStreamClass = this.lookupClass(clazz);
        return objectStreamClass == null ? new ObjectStreamClass[]{} : objectStreamClass.hierarchy();
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        int n;
        ClassLoader classLoader = this.currentLoader();
        Class[] classArray = new Class[stringArray.length];
        if (classLoader == null) {
            for (n = 0; n < stringArray.length; ++n) {
                classArray[n] = Class.forName(stringArray[n]);
            }
            classLoader = ClassLoader.getSystemClassLoader();
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                classArray[n] = Class.forName(stringArray[n], false, classLoader);
            }
        }
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean bl2 = this.resolveEnabled;
        this.resolveEnabled = bl;
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (dump) {
            this.dumpElement("STREAM MAGIC ");
        }
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        if (dump) {
            this.dumpElementln("STREAM VERSION ");
        }
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readDataFromBlock) {
            int n3 = this.blockDataBytes - this.blockDataPosition;
            if (n3 == 0) {
                this.readNextBlock();
                n3 = this.blockDataBytes - this.blockDataPosition;
            }
            n2 = Math.min(n2, n3);
            System.arraycopy(this.blockData, this.blockDataPosition, byArray, n, n2);
            this.blockDataPosition += n2;
            return n2;
        }
        return this.realInputStream.read(byArray, n, n2);
    }

    @Override
    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.realInputStream.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        boolean bl3 = this.dataInputStream.readBoolean();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return bl3;
    }

    @Override
    public byte readByte() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        byte by = this.dataInputStream.readByte();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return by;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readUnsignedByte();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        short s = this.dataInputStream.readShort();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return s;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readUnsignedShort();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    @Override
    public char readChar() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        char c = this.dataInputStream.readChar();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return c;
    }

    @Override
    public int readInt() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 4) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readInt();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    @Override
    public long readLong() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 8) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        long l = this.dataInputStream.readLong();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return l;
    }

    @Override
    public float readFloat() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 4) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        float f = this.dataInputStream.readFloat();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return f;
    }

    @Override
    public double readDouble() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 8) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        double d = this.dataInputStream.readDouble();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return d;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.dataInputStream.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dataInputStream.readFully(byArray, n, n2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    @Override
    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.prereadFields != null) {
            return this.prereadFields;
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        final ObjectStreamClass objectStreamClass = this.currentObjectStreamClass;
        final byte[] byArray = new byte[objectStreamClass.primFieldSize];
        final Object[] objectArray = new Object[objectStreamClass.objectFieldCount];
        boolean bl = this.setBlockDataMode(false);
        this.readFully(byArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.readObject();
        }
        this.setBlockDataMode(bl);
        this.prereadFields = new GetField(){

            public ObjectStreamClass getObjectStreamClass() {
                return objectStreamClass;
            }

            public boolean defaulted(String string) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = objectStreamClass.getField(string);
                if (objectStreamField != null) {
                    return objectStreamField.isPersistent() && !objectStreamField.isToSet();
                }
                try {
                    return objectStreamClass.forClass().getDeclaredField(string) != null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException(noSuchFieldException);
                }
            }

            public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Boolean.TYPE);
                if (objectStreamField == null) {
                    return bl;
                }
                return byArray[objectStreamField.getOffset()] != 0;
            }

            public char get(String string, char c) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Character.TYPE);
                if (objectStreamField == null) {
                    return c;
                }
                int n = objectStreamField.getOffset();
                return (char)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
            }

            public byte get(String string, byte by) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Byte.TYPE);
                if (objectStreamField == null) {
                    return by;
                }
                return byArray[objectStreamField.getOffset()];
            }

            public short get(String string, short s) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Short.TYPE);
                if (objectStreamField == null) {
                    return s;
                }
                int n = objectStreamField.getOffset();
                return (short)((byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
            }

            public int get(String string, int n) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Integer.TYPE);
                if (objectStreamField == null) {
                    return n;
                }
                int n2 = objectStreamField.getOffset();
                return (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
            }

            public long get(String string, long l) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Long.TYPE);
                if (objectStreamField == null) {
                    return l;
                }
                int n = objectStreamField.getOffset();
                return ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | (long)((byArray[n++] & 0xFF) << 24) | (long)((byArray[n++] & 0xFF) << 16) | (long)((byArray[n++] & 0xFF) << 8) | (long)(byArray[n] & 0xFF);
            }

            public float get(String string, float f) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Float.TYPE);
                if (objectStreamField == null) {
                    return f;
                }
                int n = objectStreamField.getOffset();
                return Float.intBitsToFloat((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
            }

            public double get(String string, double d) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Double.TYPE);
                if (objectStreamField == null) {
                    return d;
                }
                int n = objectStreamField.getOffset();
                return Double.longBitsToDouble(((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | (long)((byArray[n++] & 0xFF) << 24) | (long)((byArray[n++] & 0xFF) << 16) | (long)((byArray[n++] & 0xFF) << 8) | (long)(byArray[n] & 0xFF));
            }

            public Object get(String string, Object object) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, object == null ? null : object.getClass());
                if (objectStreamField == null) {
                    return object;
                }
                return objectArray[objectStreamField.getOffset()];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private ObjectStreamField getField(String string, Class clazz) throws IllegalArgumentException {
                ObjectStreamField objectStreamField;
                ObjectStreamField objectStreamField2;
                block18: {
                    objectStreamField2 = objectStreamClass.getField(string);
                    boolean bl = false;
                    try {
                        Class<?> clazz2;
                        block16: {
                            clazz2 = objectStreamField2.getType();
                            if (clazz != clazz2 && (clazz != null || clazz2.isPrimitive())) break block16;
                            ObjectStreamField objectStreamField3 = objectStreamField2;
                            Object var8_10 = null;
                            if (!bl && objectStreamField2 != null && !objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                                return null;
                            }
                            try {
                                Field field = objectStreamClass.forClass().getDeclaredField(string);
                                if (Modifier.isTransient(field.getModifiers())) {
                                    throw new IllegalArgumentException("no such field (non transient) " + string);
                                }
                                if (objectStreamField2 != null) return objectStreamField3;
                                if (field.getType() == clazz) return objectStreamField3;
                                throw new IllegalArgumentException("Invalid requested type for field " + string);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                if (objectStreamField2 != null) return objectStreamField3;
                                throw new IllegalArgumentException(noSuchFieldException);
                            }
                        }
                        try {
                            String string2;
                            bl = true;
                            StringBuilder stringBuilder = new StringBuilder().append("Field requested is of type ").append(clazz2.getName()).append(", but requested type was ");
                            if (clazz == null) {
                                string2 = "Object";
                                throw new IllegalArgumentException(stringBuilder.append(string2).toString());
                            }
                            string2 = clazz.getName();
                            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw illegalArgumentException;
                        }
                        objectStreamField = null;
                        Object var8_11 = null;
                        if (bl || objectStreamField2 == null || objectStreamField2.isToSet() || !objectStreamField2.isPersistent()) break block18;
                        return null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (!bl && objectStreamField2 != null && !objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                            return null;
                        }
                        try {}
                        catch (NoSuchFieldException noSuchFieldException) {
                            if (objectStreamField2 != null) throw throwable;
                            throw new IllegalArgumentException(noSuchFieldException);
                        }
                        Field field = objectStreamClass.forClass().getDeclaredField(string);
                        if (Modifier.isTransient(field.getModifiers())) {
                            throw new IllegalArgumentException("no such field (non transient) " + string);
                        }
                        if (objectStreamField2 != null) throw throwable;
                        if (field.getType() == clazz) throw throwable;
                        throw new IllegalArgumentException("Invalid requested type for field " + string);
                    }
                }
                try {}
                catch (NoSuchFieldException noSuchFieldException) {
                    if (objectStreamField2 != null) return objectStreamField;
                    throw new IllegalArgumentException(noSuchFieldException);
                }
                Field field = objectStreamClass.forClass().getDeclaredField(string);
                if (Modifier.isTransient(field.getModifiers())) {
                    throw new IllegalArgumentException("no such field (non transient) " + string);
                }
                if (objectStreamField2 != null) return objectStreamField;
                if (field.getType() == clazz) return objectStreamField;
                throw new IllegalArgumentException("Invalid requested type for field " + string);
            }
        };
        this.fieldsAlreadyRead = true;
        return this.prereadFields;
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected Object readObjectOverride() throws ClassNotFoundException, IOException, OptionalDataException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private int assignNewHandle(Object object, boolean bl) {
        int n = this.nextOID;
        this.nextOID = n + 1;
        this.rememberHandle(object, bl, n);
        return n;
    }

    private void rememberHandle(Object object, boolean bl, int n) {
        this.handles.put(n, new Pair<Boolean, Object>(bl, object));
    }

    private Object lookupHandle(int n) throws ObjectStreamException {
        Pair<Boolean, Object> pair = this.handles.get(n);
        if (pair == null) {
            throw new StreamCorruptedException("The handle, " + Integer.toHexString(n) + ", is invalid.");
        }
        if (!pair.getLeft().booleanValue()) {
            throw new InvalidObjectException("The handle, " + Integer.toHexString(n) + ", is not shared.");
        }
        return pair.getRight();
    }

    private Object processResolution(ObjectStreamClass objectStreamClass, Object object, int n, boolean bl) throws IOException {
        block18: {
            if (objectStreamClass != null && object instanceof Serializable) {
                try {
                    Method method = objectStreamClass.readResolveMethod;
                    if (method != null) {
                        object = method.invoke(object, new Object[0]);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof ObjectStreamException) {
                        throw (ObjectStreamException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (!(throwable instanceof Error)) break block18;
                    throw (Error)throwable;
                }
            }
        }
        if (this.resolveEnabled) {
            object = this.resolveObject(object);
        }
        this.rememberHandle(object, bl, n);
        if (!bl) {
            if (object instanceof byte[]) {
                return ((byte[])object).clone();
            }
            if (object instanceof short[]) {
                return ((short[])object).clone();
            }
            if (object instanceof int[]) {
                return ((int[])object).clone();
            }
            if (object instanceof long[]) {
                return ((long[])object).clone();
            }
            if (object instanceof char[]) {
                return ((char[])object).clone();
            }
            if (object instanceof boolean[]) {
                return ((boolean[])object).clone();
            }
            if (object instanceof float[]) {
                return ((float[])object).clone();
            }
            if (object instanceof double[]) {
                return ((double[])object).clone();
            }
            if (object instanceof Object[]) {
                return ((Object[])object).clone();
            }
        }
        return object;
    }

    private void clearHandles() {
        this.handles.clear();
        this.nextOID = 0x7E0000;
    }

    private void readNextBlock() throws IOException {
        byte by = this.realInputStream.readByte();
        while (by == 121) {
            if (dump) {
                this.dumpElementln("RESET");
            }
            this.clearHandles();
            by = this.realInputStream.readByte();
        }
        this.readNextBlock(by);
    }

    private void readNextBlock(byte by) throws IOException {
        if (by == 119) {
            if (dump) {
                this.dumpElement("BLOCK DATA SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else if (by == 122) {
            if (dump) {
                this.dumpElement("BLOCK DATA LONG SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readInt();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private void readArrayElements(Object object, Class clazz) throws ClassNotFoundException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = this.realInputStream.readBoolean();
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = this.realInputStream.readByte();
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = this.realInputStream.readChar();
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.realInputStream.readDouble();
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.realInputStream.readFloat();
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.realInputStream.readInt();
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = this.realInputStream.readLong();
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = this.realInputStream.readShort();
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.readObject();
            }
        }
    }

    private void readFields(Object object, ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fieldMapping;
        block11: for (int i = 0; i < objectStreamFieldArray.length; i += 2) {
            char c;
            String string;
            boolean bl;
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ObjectStreamField objectStreamField2 = objectStreamFieldArray[i + 1];
            boolean bl2 = objectStreamField != null && objectStreamField.getOffset() >= 0 && objectStreamField.isToSet();
            boolean bl3 = bl = objectStreamField2 != null && objectStreamField2.isToSet();
            if (objectStreamField != null) {
                string = objectStreamField.getName();
                c = objectStreamField.getTypeCode();
            } else {
                string = objectStreamField2.getName();
                c = objectStreamField2.getTypeCode();
            }
            switch (c) {
                case 'Z': {
                    boolean bl4;
                    boolean bl5 = bl4 = bl2 ? this.realInputStream.readBoolean() : false;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + bl4);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setBooleanField(object, bl4);
                    continue block11;
                }
                case 'B': {
                    byte by;
                    byte by2 = by = bl2 ? this.realInputStream.readByte() : (byte)0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + by);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setByteField(object, by);
                    continue block11;
                }
                case 'C': {
                    char c2;
                    char c3 = c2 = bl2 ? this.realInputStream.readChar() : (char)'\u0000';
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + c2);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setCharField(object, c2);
                    continue block11;
                }
                case 'D': {
                    double d;
                    double d2 = d = bl2 ? this.realInputStream.readDouble() : 0.0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + d);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setDoubleField(object, d);
                    continue block11;
                }
                case 'F': {
                    float f;
                    float f2 = f = bl2 ? this.realInputStream.readFloat() : 0.0f;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + f);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setFloatField(object, f);
                    continue block11;
                }
                case 'I': {
                    int n;
                    int n2 = n = bl2 ? this.realInputStream.readInt() : 0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + n);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setIntField(object, n);
                    continue block11;
                }
                case 'J': {
                    long l;
                    long l2 = l = bl2 ? this.realInputStream.readLong() : 0L;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + l);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setLongField(object, l);
                    continue block11;
                }
                case 'S': {
                    short s;
                    short s2 = s = bl2 ? this.realInputStream.readShort() : (short)0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + s);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setShortField(object, s);
                    continue block11;
                }
                case 'L': 
                case '[': {
                    Object object2;
                    Object object3 = object2 = bl2 ? this.readObject() : null;
                    if (!bl) continue block11;
                    objectStreamField2.setObjectField(object, object2);
                    continue block11;
                }
                default: {
                    throw new InternalError("Invalid type code: " + c);
                }
            }
        }
    }

    private boolean setBlockDataMode(boolean bl) {
        boolean bl2 = this.readDataFromBlock;
        this.readDataFromBlock = bl;
        this.dataInputStream = bl ? this.blockDataInput : this.realInputStream;
        return bl2;
    }

    private Object newObject(Class clazz, Constructor constructor) throws ClassNotFoundException, IOException {
        if (constructor == null) {
            throw new InvalidClassException("Missing accessible no-arg base class constructor for " + clazz.getName());
        }
        try {
            return VMObjectInputStream.allocateObject(clazz, constructor.getDeclaringClass(), constructor);
        }
        catch (InstantiationException instantiationException) {
            throw (ClassNotFoundException)new ClassNotFoundException("Instance of " + clazz + " could not be created").initCause(instantiationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeValidators() throws InvalidObjectException {
        try {
            for (ValidatorAndPriority validatorAndPriority : this.currentObjectValidators) {
                ObjectInputValidation objectInputValidation = validatorAndPriority.validator;
                objectInputValidation.validateObject();
            }
            Object var5_4 = null;
            this.currentObjectValidators = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.currentObjectValidators = null;
            throw throwable;
        }
    }

    private void callReadMethod(Method method, Class clazz, Object object) throws ClassNotFoundException, IOException {
        try {
            method.invoke(object, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw (IOException)new IOException("Exception thrown from readObject() on " + clazz).initCause(invocationTargetException);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Failure invoking readObject() on " + clazz).initCause(exception);
        }
        this.prereadFields = null;
    }

    private void dumpElement(String string) {
        System.out.print(string);
    }

    private void dumpElementln(String string) {
        System.out.println(string);
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(" ");
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    private void dumpElementln(String string, Object object) {
        try {
            System.out.print(string);
            if (Proxy.isProxyClass(object.getClass())) {
                System.out.println(object.getClass());
            } else {
                System.out.println(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(" ");
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    private static final class ValidatorAndPriority
    implements Comparable {
        int priority;
        ObjectInputValidation validator;

        ValidatorAndPriority(ObjectInputValidation objectInputValidation, int n) {
            this.priority = n;
            this.validator = objectInputValidation;
        }

        public int compareTo(Object object) {
            ValidatorAndPriority validatorAndPriority = (ValidatorAndPriority)object;
            return this.priority - validatorAndPriority.priority;
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

