/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.SystemProperties;
import gnu.java.nio.charset.EncodingHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class InputStreamReader
extends Reader {
    private InputStream in;
    private CharsetDecoder decoder;
    private boolean isDone = false;
    private float maxBytesPerChar;
    private ByteBuffer byteBuffer;
    private String encoding;
    private char savedSurrogate;
    private boolean hasSavedSurrogate = false;
    private byte[] bytesCache;
    private Object cacheLock = new Object();

    public InputStreamReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        try {
            this.encoding = SystemProperties.getProperty("file.encoding");
            if (EncodingHelper.isISOLatin1(this.encoding)) {
                this.encoding = "ISO8859_1";
                this.maxBytesPerChar = 1.0f;
                this.decoder = null;
                return;
            }
            Charset charset = EncodingHelper.getCharset(this.encoding);
            this.decoder = charset.newDecoder();
            this.encoding = EncodingHelper.getOldCanonical(charset.name());
            try {
                this.maxBytesPerChar = charset.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.maxBytesPerChar = 1.0f;
            }
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.reset();
        }
        catch (RuntimeException runtimeException) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        if (inputStream == null || string == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        if (EncodingHelper.isISOLatin1(string)) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
            return;
        }
        try {
            Charset charset = EncodingHelper.getCharset(string);
            try {
                this.maxBytesPerChar = charset.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.maxBytesPerChar = 1.0f;
            }
            this.decoder = charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.reset();
            this.encoding = EncodingHelper.getOldCanonical(charset.name());
        }
        catch (RuntimeException runtimeException) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
    }

    public InputStreamReader(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.decoder = charset.newDecoder();
        try {
            this.maxBytesPerChar = charset.newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.maxBytesPerChar = 1.0f;
        }
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.reset();
        this.encoding = EncodingHelper.getOldCanonical(charset.name());
    }

    public InputStreamReader(InputStream inputStream, CharsetDecoder charsetDecoder) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.decoder = charsetDecoder;
        Charset charset = charsetDecoder.charset();
        try {
            this.maxBytesPerChar = charset == null ? 1.0f : charset.newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.maxBytesPerChar = 1.0f;
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        charsetDecoder.reset();
        this.encoding = charset == null ? "US-ASCII" : EncodingHelper.getOldCanonical(charsetDecoder.charset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.decoder != null) {
                this.decoder.reset();
            }
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.isDone = true;
            this.decoder = null;
        }
    }

    public String getEncoding() {
        return this.in != null ? this.encoding : null;
    }

    public boolean ready() throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        return this.in.available() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        byte[] byArray;
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        if (this.isDone) {
            return -1;
        }
        if (this.decoder != null) {
            Object object;
            int n3;
            byte[] byArray2;
            int n4 = (int)((double)n2 * (double)this.maxBytesPerChar);
            if (this.byteBuffer != null) {
                n4 = Math.max(n4, this.byteBuffer.remaining());
            }
            Object object2 = this.cacheLock;
            synchronized (object2) {
                byArray2 = this.bytesCache;
                if (byArray2 == null || byArray2.length < n4) {
                    byArray2 = new byte[n4];
                } else {
                    this.bytesCache = null;
                }
            }
            int n5 = 0;
            if (this.byteBuffer != null) {
                n5 = this.byteBuffer.remaining();
                this.byteBuffer.get(byArray2, 0, n5);
            }
            if (n4 - n5 > 0) {
                n3 = this.in.read(byArray2, n5, n4 - n5);
                if (n3 == -1) {
                    n3 = n5;
                    this.isDone = true;
                } else {
                    n3 += n5;
                }
            } else {
                n3 = n5;
            }
            this.byteBuffer = ByteBuffer.wrap(byArray2, 0, n3);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            int n6 = charBuffer.position();
            if (this.hasSavedSurrogate) {
                this.hasSavedSurrogate = false;
                charBuffer.put(this.savedSurrogate);
                ++n3;
            }
            CoderResult coderResult = this.decoder.decode(this.byteBuffer, charBuffer, this.isDone);
            this.decoder.reset();
            if (coderResult.isOverflow() && charBuffer.hasRemaining()) {
                object = CharBuffer.allocate(2);
                coderResult = this.decoder.decode(this.byteBuffer, (CharBuffer)object, this.isDone);
                ((Buffer)object).flip();
                if (((Buffer)object).hasRemaining()) {
                    charBuffer.put(((CharBuffer)object).get());
                    this.savedSurrogate = ((CharBuffer)object).get();
                    this.hasSavedSurrogate = true;
                    this.isDone = false;
                }
            }
            if (this.byteBuffer.hasRemaining()) {
                this.byteBuffer.compact();
                this.byteBuffer.flip();
                this.isDone = false;
            } else {
                this.byteBuffer = null;
            }
            n3 = charBuffer.position() - n6;
            object = this.cacheLock;
            synchronized (object) {
                if (this.byteBuffer == null && (this.bytesCache == null || this.bytesCache.length < byArray2.length)) {
                    this.bytesCache = byArray2;
                }
            }
            return n3 <= 0 ? -1 : n3;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            byArray = this.bytesCache;
            if (byArray == null || n2 < byArray.length) {
                byArray = new byte[n2];
            } else {
                this.bytesCache = null;
            }
        }
        int n7 = this.in.read(byArray);
        for (int i = 0; i < n7; ++i) {
            cArray[n + i] = (char)(byArray[i] & 0xFF);
        }
        Object object3 = this.cacheLock;
        synchronized (object3) {
            if (this.bytesCache == null || this.bytesCache.length < byArray.length) {
                this.bytesCache = byArray;
            }
        }
        return n7;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        return n > 0 ? cArray[0] : -1;
    }

    public long skip(long l) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        return super.skip(l);
    }
}

