/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;
    private byte[] buf;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += n2;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public final synchronized void writeShort(int n) throws IOException {
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n));
    }

    public final synchronized void writeChar(int n) throws IOException {
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n));
    }

    public final synchronized void writeInt(int n) throws IOException {
        this.write((byte)(0xFF & n >> 24));
        this.write((byte)(0xFF & n >> 16));
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n));
    }

    public final synchronized void writeLong(long l) throws IOException {
        this.write((byte)(0xFFL & l >> 56));
        this.write((byte)(0xFFL & l >> 48));
        this.write((byte)(0xFFL & l >> 40));
        this.write((byte)(0xFFL & l >> 32));
        this.write((byte)(0xFFL & l >> 24));
        this.write((byte)(0xFFL & l >> 16));
        this.write((byte)(0xFFL & l >> 8));
        this.write((byte)(0xFFL & l));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    long getUTFlength(String string, int n, long l) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++l;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                l += 2L;
                continue;
            }
            l += 3L;
        }
        return l;
    }

    public final synchronized void writeUTF(String string) throws IOException {
        long l = this.getUTFlength(string, 0, 0L);
        if (l > 65535L) {
            throw new UTFDataFormatException();
        }
        this.writeUTFShort(string, (int)l);
    }

    final synchronized void writeUTFShort(String string, int n) throws IOException {
        this.writeShort(n);
        this.writeUTFBytes(string);
    }

    final synchronized void writeUTFLong(String string, long l) throws IOException {
        this.writeLong(l);
        this.writeUTFBytes(string);
    }

    private final synchronized void writeUTFBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        if (this.buf == null) {
            this.buf = new byte[512];
        }
        while (true) {
            if (n2 < n && n3 < this.buf.length - 3) {
                char c;
                if ((c = string.charAt(n2++)) >= '\u0001' && c <= '\u007f') {
                    this.buf[n3++] = (byte)c;
                    continue;
                }
                if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    this.buf[n3++] = (byte)(0xC0 | 0x1F & c >> 6);
                    this.buf[n3++] = (byte)(0x80 | 0x3F & c);
                    continue;
                }
                this.buf[n3++] = (byte)(0xE0 | 0xF & c >> 12);
                this.buf[n3++] = (byte)(0x80 | 0x3F & c >> 6);
                this.buf[n3++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            this.write(this.buf, 0, n3);
            n3 = 0;
            if (n2 >= n) break;
        }
    }
}

