/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TooManyListenersException;

public class BeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices {
    private static final long serialVersionUID = -8494482757288719206L;
    protected transient ArrayList bcsListeners;
    protected transient BCSSProxyServiceProvider proxy;
    protected transient int serializable;
    protected transient HashMap services;
    private transient HashMap serviceUsers;
    private transient HashMap serviceRequests;
    private transient HashMap serviceLeases;

    public BeanContextServicesSupport() {
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices) {
        super(beanContextServices);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale) {
        super(beanContextServices, locale);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale, boolean bl) {
        super(beanContextServices, locale, bl);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale, boolean bl, boolean bl2) {
        super(beanContextServices, locale, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(beanContextServicesListener)) {
                this.bcsListeners.add(beanContextServicesListener);
            }
        }
    }

    public boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return this.addService(clazz, beanContextServiceProvider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                if (this.services.containsKey(clazz)) {
                    return false;
                }
                this.services.put(clazz, this.createBCSSServiceProvider(clazz, beanContextServiceProvider));
                if (beanContextServiceProvider instanceof Serializable) {
                    ++this.serializable;
                }
                if (bl) {
                    this.fireServiceAdded(clazz);
                }
                return true;
            }
        }
    }

    protected void bcsPreDeserializationHook(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.serializable = objectInputStream.readInt();
        for (int i = 0; i < this.serializable; ++i) {
            BCSSServiceProvider bCSSServiceProvider = (BCSSServiceProvider)objectInputStream.readObject();
            this.addService(bCSSServiceProvider.getServiceClass(), bCSSServiceProvider.getServiceProvider());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bcsPreSerializationHook(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.serializable);
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            for (BCSSServiceProvider bCSSServiceProvider : this.services.values()) {
                if (!(bCSSServiceProvider.getServiceProvider() instanceof Serializable)) continue;
                objectOutputStream.writeObject(bCSSServiceProvider);
            }
        }
    }

    protected void childJustRemovedHook(Object object, BeanContextSupport.BCSChild bCSChild) {
        if (object instanceof BeanContextChild) {
            BeanContextChild beanContextChild = (BeanContextChild)object;
            Iterator iterator = ((List)this.serviceUsers.get(beanContextChild)).iterator();
            while (iterator.hasNext()) {
                this.releaseService(beanContextChild, this, iterator.next());
            }
            this.serviceUsers.remove(beanContextChild);
        }
    }

    protected BeanContextSupport.BCSChild createBCSChild(Object object, Object object2) {
        return new BCSSChild(object, object2);
    }

    protected BCSSServiceProvider createBCSSServiceProvider(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return new BCSSServiceProvider(clazz, beanContextServiceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceAdded(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            int n = this.bcsListeners.size();
            for (int i = 0; i < n; ++i) {
                BeanContextServicesListener beanContextServicesListener = (BeanContextServicesListener)this.bcsListeners.get(i);
                beanContextServicesListener.serviceAvailable(beanContextServiceAvailableEvent);
            }
        }
    }

    protected final void fireServiceAdded(Class clazz) {
        this.fireServiceAdded(new BeanContextServiceAvailableEvent(this, clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            int n = this.bcsListeners.size();
            for (int i = 0; i < n; ++i) {
                BeanContextServicesListener beanContextServicesListener = (BeanContextServicesListener)this.bcsListeners.get(i);
                beanContextServicesListener.serviceRevoked(beanContextServiceRevokedEvent);
            }
            List list2 = (List)this.serviceRequests.get(beanContextServiceRevokedEvent.getServiceClass());
            if (list2 != null) {
                for (ServiceRequest serviceRequest : list2) {
                    serviceRequest.getListener().serviceRevoked(beanContextServiceRevokedEvent);
                }
            }
        }
    }

    protected final void fireServiceRevoked(Class clazz, boolean bl) {
        this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, clazz, bl));
    }

    public BeanContextServices getBeanContextServicesPeer() {
        return (BeanContextServices)this.beanContextChildPeer;
    }

    protected static final BeanContextServicesListener getChildBeanContextServicesListener(Object object) {
        if (object instanceof BeanContextServicesListener) {
            return (BeanContextServicesListener)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCurrentServiceClasses() {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                return this.services.keySet().iterator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCurrentServiceSelectors(Class clazz) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                BeanContextServiceProvider beanContextServiceProvider = ((BCSSServiceProvider)this.services.get(clazz)).getServiceProvider();
                if (beanContextServiceProvider == null) {
                    return null;
                }
                return beanContextServiceProvider.getCurrentServiceSelectors(this, clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild beanContextChild, Object object, Class clazz, Object object2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
        Object object3 = globalHierarchyLock;
        synchronized (object3) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                Collection<Class<Object>> collection;
                Object object4;
                BeanContextServiceProvider beanContextServiceProvider = ((BCSSServiceProvider)this.services.get(clazz)).getServiceProvider();
                if (beanContextServiceProvider != null) {
                    object4 = beanContextServiceProvider.getService(this, object, clazz, object2);
                    collection = (List)this.serviceUsers.get(beanContextChild);
                    if (collection == null) {
                        collection = new ArrayList<Class>();
                        this.serviceUsers.put(beanContextChild, collection);
                    }
                    collection.add(clazz);
                } else {
                    collection = this.getBeanContextServicesPeer();
                    object4 = collection != null ? collection.getService(beanContextChild, object, clazz, object2, beanContextServiceRevokedListener) : null;
                }
                if (object4 != null) {
                    collection = new ServiceRequest(object, beanContextServiceRevokedListener);
                    HashSet hashSet = (HashSet)this.serviceRequests.get(clazz);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                        this.serviceRequests.put(clazz, hashSet);
                    }
                    hashSet.add(collection);
                    ServiceLease serviceLease = new ServiceLease(object, object4);
                    this.serviceLeases.put(serviceLease, beanContextServiceProvider);
                }
                return object4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasService(Class clazz) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                return this.services.containsKey(clazz);
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.bcsListeners = new ArrayList();
        this.services = new HashMap();
        this.serviceUsers = new HashMap();
        this.serviceRequests = new HashMap();
        this.serviceLeases = new HashMap();
    }

    protected void initializeBeanContextResources() {
    }

    protected void releaseBeanContextResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseService(BeanContextChild beanContextChild, Object object, Object object2) {
        Object object3 = globalHierarchyLock;
        synchronized (object3) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                ServiceLease serviceLease = new ServiceLease(object, object2);
                BeanContextServiceProvider beanContextServiceProvider = (BeanContextServiceProvider)this.serviceLeases.get(serviceLease);
                if (beanContextServiceProvider != null) {
                    beanContextServiceProvider.releaseService(this, object, object2);
                } else {
                    BeanContextServices beanContextServices = this.getBeanContextServicesPeer();
                    if (beanContextServices != null) {
                        beanContextServices.releaseService(beanContextChild, object, object2);
                    }
                }
                this.serviceLeases.remove(serviceLease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(beanContextServicesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                this.fireServiceRevoked(clazz, bl);
                this.services.remove(clazz);
                if (beanContextServiceProvider instanceof Serializable) {
                    --this.serializable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            Class clazz = beanContextServiceAvailableEvent.getServiceClass();
            if (this.services.containsKey(clazz)) {
                return;
            }
            Iterator iterator = this.bcsChildren();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof BeanContextServices)) continue;
                ((BeanContextServices)e).serviceAvailable(beanContextServiceAvailableEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            Class clazz = beanContextServiceRevokedEvent.getServiceClass();
            if (this.services.containsKey(clazz)) {
                return;
            }
            Iterator iterator = this.bcsChildren();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof BeanContextServices)) continue;
                ((BeanContextServices)e).serviceRevoked(beanContextServiceRevokedEvent);
            }
        }
    }

    private static class ServiceLease
    extends Request {
        private Object service;

        public ServiceLease(Object object, Object object2) {
            super(object);
            this.service = object2;
        }

        public boolean equals(Object object) {
            if (object instanceof ServiceLease) {
                ServiceLease serviceLease = (ServiceLease)object;
                return super.equals(object) && serviceLease.getService().equals(this.service);
            }
            return false;
        }

        public Object getService() {
            return this.service;
        }
    }

    private static class ServiceRequest
    extends Request {
        private BeanContextServiceRevokedListener listener;

        public ServiceRequest(Object object, BeanContextServiceRevokedListener beanContextServiceRevokedListener) {
            super(object);
            this.listener = beanContextServiceRevokedListener;
        }

        public boolean equals(Object object) {
            if (object instanceof ServiceRequest) {
                ServiceRequest serviceRequest = (ServiceRequest)object;
                return super.equals(object) && serviceRequest.getListener().equals(this.listener);
            }
            return false;
        }

        public BeanContextServiceRevokedListener getListener() {
            return this.listener;
        }
    }

    private static abstract class Request {
        private Object requestor;

        public Request(Object object) {
            this.requestor = object;
        }

        public boolean equals(Object object) {
            if (object instanceof Request) {
                Request request = (Request)object;
                return request.getRequestor().equals(this.requestor);
            }
            return false;
        }

        public Object getRequestor() {
            return this.requestor;
        }
    }

    protected static class BCSSServiceProvider
    implements Serializable {
        private static final long serialVersionUID = 861278251667444782L;
        protected BeanContextServiceProvider serviceProvider;
        private Class serviceClass;

        private BCSSServiceProvider(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
            this.serviceClass = clazz;
            this.serviceProvider = beanContextServiceProvider;
        }

        protected BeanContextServiceProvider getServiceProvider() {
            return this.serviceProvider;
        }

        private Class getServiceClass() {
            return this.serviceClass;
        }
    }

    protected class BCSSProxyServiceProvider
    implements BeanContextServiceProvider,
    BeanContextServiceRevokedListener {
        private static final long serialVersionUID = 7078212910685744490L;
        private BeanContextServiceProvider provider;

        BCSSProxyServiceProvider(BeanContextServiceProvider beanContextServiceProvider) {
            this.provider = beanContextServiceProvider;
        }

        public Iterator getCurrentServiceSelectors(BeanContextServices beanContextServices, Class clazz) {
            return this.provider.getCurrentServiceSelectors(beanContextServices, clazz);
        }

        public Object getService(BeanContextServices beanContextServices, Object object, Class clazz, Object object2) {
            return this.provider.getService(beanContextServices, object, clazz, object2);
        }

        public void releaseService(BeanContextServices beanContextServices, Object object, Object object2) {
            this.provider.releaseService(beanContextServices, object, object2);
        }

        public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
            if (this.provider instanceof BeanContextServiceRevokedListener) {
                ((BeanContextServiceRevokedListener)((Object)this.provider)).serviceRevoked(beanContextServiceRevokedEvent);
            }
        }
    }

    protected class BCSSChild
    extends BeanContextSupport.BCSChild {
        private static final long serialVersionUID = -3263851306889194873L;

        BCSSChild(Object object, Object object2) {
            super(BeanContextServicesSupport.this, object, object2);
        }
    }
}

