/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListenerProxy;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class VetoableChangeSupport
implements Serializable {
    private static final long serialVersionUID = -5090210921595982017L;
    private Hashtable children;
    private final Object source;
    private static final int vetoableChangeSupportSerializedDataVersion = 2;
    private transient Vector listeners;

    public VetoableChangeSupport(Object object) {
        this.source = object;
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            return;
        }
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.addVetoableChangeListener(vetoableChangeListenerProxy.propertyName, (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(vetoableChangeListener);
        }
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            this.removeVetoableChangeListener(vetoableChangeListenerProxy.propertyName, (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
        } else if (this.listeners != null) {
            this.listeners.remove(vetoableChangeListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        ArrayList<VetoableChangeListenerProxy> arrayList = new ArrayList<VetoableChangeListenerProxy>();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        if (this.children != null) {
            int n = this.children.size();
            Iterator iterator = this.children.entrySet().iterator();
            while (--n >= 0) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Vector vector = ((VetoableChangeSupport)entry.getValue()).listeners;
                int n2 = vector.size();
                while (--n2 >= 0) {
                    arrayList.add(new VetoableChangeListenerProxy(string, (VetoableChangeListener)vector.get(n2)));
                }
            }
        }
        return arrayList.toArray(new VetoableChangeListener[arrayList.size()]);
    }

    public synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        Object object;
        if (string == null || vetoableChangeListener == null) {
            return;
        }
        while (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            object = (VetoableChangeListenerProxy)vetoableChangeListener;
            if (string == null ? ((VetoableChangeListenerProxy)object).propertyName != null : !string.equals(((VetoableChangeListenerProxy)object).propertyName)) {
                return;
            }
            vetoableChangeListener = (VetoableChangeListener)((EventListenerProxy)object).getListener();
        }
        object = null;
        if (this.children == null) {
            this.children = new Hashtable();
        } else {
            object = (VetoableChangeSupport)this.children.get(string);
        }
        if (object == null) {
            object = new VetoableChangeSupport(this.source);
            ((VetoableChangeSupport)object).listeners = new Vector();
            this.children.put(string, object);
        }
        ((VetoableChangeSupport)object).listeners.add(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (this.children == null) {
            return;
        }
        VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
        if (vetoableChangeSupport == null) {
            return;
        }
        while (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
            if (string == null ? vetoableChangeListenerProxy.propertyName != null : !string.equals(vetoableChangeListenerProxy.propertyName)) {
                return;
            }
            vetoableChangeListener = (VetoableChangeListener)vetoableChangeListenerProxy.getListener();
        }
        vetoableChangeSupport.listeners.remove(vetoableChangeListener);
        if (vetoableChangeSupport.listeners.isEmpty()) {
            this.children.remove(string);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String string) {
        if (this.children == null) {
            return new VetoableChangeListener[0];
        }
        VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)this.children.get(string);
        if (vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return vetoableChangeSupport.listeners.toArray((S[])new VetoableChangeListener[vetoableChangeSupport.listeners.size()]);
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        if (n != n2) {
            this.fireVetoableChange(new PropertyChangeEvent(this.source, string, n, n2));
        }
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        if (bl != bl2) {
            this.fireVetoableChange(new PropertyChangeEvent(this.source, string, bl, bl2));
        }
    }

    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        VetoableChangeSupport vetoableChangeSupport;
        Hashtable hashtable;
        if (propertyChangeEvent.oldValue != null && propertyChangeEvent.oldValue.equals(propertyChangeEvent.newValue)) {
            return;
        }
        Vector vector = this.listeners;
        if (vector != null) {
            int n = vector.size();
            try {
                while (--n >= 0) {
                    ((VetoableChangeListener)vector.get(n)).vetoableChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyChangeEvent = propertyChangeEvent.rollback();
                int n2 = n;
                n = vector.size();
                while (--n >= n2) {
                    ((VetoableChangeListener)vector.get(n)).vetoableChange(propertyChangeEvent);
                }
                throw propertyVetoException;
            }
        }
        if ((hashtable = this.children) != null && propertyChangeEvent.propertyName != null && (vetoableChangeSupport = (VetoableChangeSupport)hashtable.get(propertyChangeEvent.propertyName)) != null) {
            Vector vector2 = vetoableChangeSupport.listeners;
            int n = vector2 == null ? 0 : vector2.size();
            try {
                while (--n >= 0) {
                    ((VetoableChangeListener)vector2.get(n)).vetoableChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyChangeEvent = propertyChangeEvent.rollback();
                int n3 = n;
                n = vector.size();
                while (--n >= 0) {
                    ((VetoableChangeListener)vector.get(n)).vetoableChange(propertyChangeEvent);
                }
                n = vector2.size();
                while (--n >= n3) {
                    ((VetoableChangeListener)vector2.get(n)).vetoableChange(propertyChangeEvent);
                }
                throw propertyVetoException;
            }
        }
    }

    public synchronized boolean hasListeners(String string) {
        return this.listeners != null || this.children != null && this.children.get(string) != null;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.listeners != null) {
            int n = this.listeners.size();
            while (--n >= 0) {
                if (!(this.listeners.get(n) instanceof Serializable)) continue;
                objectOutputStream.writeObject(this.listeners.get(n));
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)objectInputStream.readObject();
        while (vetoableChangeListener != null) {
            this.addVetoableChangeListener(vetoableChangeListener);
            vetoableChangeListener = (VetoableChangeListener)objectInputStream.readObject();
        }
        if (this.children != null) {
            int n = this.children.size();
            Iterator iterator = this.children.entrySet().iterator();
            while (--n >= 0) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                VetoableChangeSupport vetoableChangeSupport = (VetoableChangeSupport)entry.getValue();
                if (vetoableChangeSupport.listeners == null) {
                    vetoableChangeSupport.listeners = new Vector();
                }
                if (vetoableChangeSupport.children != null) {
                    vetoableChangeSupport.listeners.addAll(Arrays.asList(vetoableChangeSupport.getVetoableChangeListeners(string)));
                }
                if (vetoableChangeSupport.listeners.size() == 0) {
                    iterator.remove();
                    continue;
                }
                vetoableChangeSupport.children = null;
            }
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }
}

