/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.lang.CPStringBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Statement {
    private Object target;
    private String methodName;
    private Object[] arguments;
    private transient Method method;
    private transient Constructor ctor;
    private static Class[] wrappers = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class};
    private static Class[] natives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};

    public Statement(Object object, String string, Object[] objectArray) {
        this.target = object;
        this.methodName = string;
        this.arguments = objectArray != null ? objectArray : new Object[]{};
    }

    public void execute() throws Exception {
        this.doExecute();
    }

    private Class unwrap(Class clazz) {
        for (int i = 0; i < wrappers.length; ++i) {
            if (clazz != wrappers[i]) continue;
            return natives[i];
        }
        return null;
    }

    private boolean compatible(Class[] classArray, Class[] classArray2) {
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz;
            if (classArray2[i] == null || (clazz = this.unwrap(classArray2[i])) != null && classArray[i].isPrimitive() && classArray[i].isAssignableFrom(clazz) || classArray[i].isAssignableFrom(classArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean moreSpecific(Class[] classArray, Class[] classArray2) {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i].isAssignableFrom(classArray[i])) continue;
            return false;
        }
        return true;
    }

    final Object doExecute() throws Exception {
        Class<? extends Object> clazz = this.target instanceof Class ? (Class<? extends Object>)this.target : this.target.getClass();
        Object[] objectArray = this.arguments == null ? new Object[]{} : this.arguments;
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : null;
        }
        if (this.target.getClass().isArray()) {
            if (this.methodName.equals("get") && classArray.length == 1) {
                return Array.get(this.target, ((Number)objectArray[0]).intValue());
            }
            if (this.methodName.equals("set") && classArray.length == 2) {
                Object object = Array.get(this.target, ((Number)objectArray[0]).intValue());
                Array.set(this.target, ((Number)objectArray[0]).intValue(), objectArray[1]);
                return object;
            }
            throw new NoSuchMethodException("No matching method for statement " + this.toString());
        }
        if (this.method != null) {
            return this.method.invoke(this.target, objectArray);
        }
        if (this.ctor != null) {
            return this.ctor.newInstance(objectArray);
        }
        if (this.methodName.equals("new") && this.target instanceof Class) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Class[] classArray2 = constructorArray[i].getParameterTypes();
                if (classArray2.length != objectArray.length || !this.compatible(classArray2, classArray)) continue;
                if (this.ctor == null) {
                    this.ctor = constructorArray[i];
                    continue;
                }
                Class[] classArray3 = this.ctor.getParameterTypes();
                if (!this.moreSpecific(classArray2, classArray3)) continue;
                this.ctor = constructorArray[i];
            }
            if (this.ctor == null) {
                throw new InstantiationException("No matching constructor for statement " + this.toString());
            }
            return this.ctor.newInstance(objectArray);
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class[] classArray4;
            if (!methodArray[i].getName().equals(this.methodName) || (classArray4 = methodArray[i].getParameterTypes()).length != objectArray.length || !this.compatible(classArray4, classArray)) continue;
            if (this.method == null) {
                this.method = methodArray[i];
                continue;
            }
            Class[] classArray5 = this.method.getParameterTypes();
            if (!this.moreSpecific(classArray4, classArray5)) continue;
            this.method = methodArray[i];
        }
        if (this.method == null) {
            throw new NoSuchMethodException("No matching method for statement " + this.toString());
        }
        if (this.method.equals(Class.class.getMethod("forName", String.class))) {
            return Class.forName((String)objectArray[0], true, ClassLoader.getSystemClassLoader());
        }
        try {
            return this.method.invoke(this.target, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("method: " + this.method);
            for (int i = 0; i < objectArray.length; ++i) {
                System.err.println("args[" + i + "]: " + objectArray[i]);
            }
            throw illegalArgumentException;
        }
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        String string = this.target != null ? this.target.getClass().getSimpleName() : "null";
        cPStringBuilder.append(string);
        cPStringBuilder.append(".");
        cPStringBuilder.append(this.methodName);
        cPStringBuilder.append("(");
        String string2 = "";
        for (int i = 0; i < this.arguments.length; ++i) {
            cPStringBuilder.append(string2);
            cPStringBuilder.append(this.arguments[i] == null ? "null" : (this.arguments[i] instanceof String ? "\"" + this.arguments[i] + "\"" : this.arguments[i].getClass().getSimpleName()));
            string2 = ", ";
        }
        cPStringBuilder.append(");");
        return cPStringBuilder.toString();
    }
}

