/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.lang.ClassHelper;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;
import java.util.Vector;

class ExplicitInfo {
    BeanDescriptor explicitBeanDescriptor;
    BeanInfo[] explicitBeanInfo;
    PropertyDescriptor[] explicitPropertyDescriptors;
    EventSetDescriptor[] explicitEventSetDescriptors;
    MethodDescriptor[] explicitMethodDescriptors;
    int defaultProperty;
    int defaultEvent;
    Image[] im = new Image[4];
    Class propertyStopClass;
    Class eventStopClass;
    Class methodStopClass;
    static Hashtable explicitBeanInfos = new Hashtable();
    static Vector emptyBeanInfos = new Vector();

    ExplicitInfo(Class clazz, Class clazz2) {
        while (clazz != null && !clazz.equals(clazz2)) {
            BeanInfo beanInfo = ExplicitInfo.findExplicitBeanInfo(clazz);
            if (beanInfo != null) {
                if (this.explicitBeanDescriptor == null) {
                    this.explicitBeanDescriptor = beanInfo.getBeanDescriptor();
                }
                if (this.explicitBeanInfo == null) {
                    this.explicitBeanInfo = beanInfo.getAdditionalBeanInfo();
                }
                if (this.explicitPropertyDescriptors == null && beanInfo.getPropertyDescriptors() != null) {
                    this.explicitPropertyDescriptors = beanInfo.getPropertyDescriptors();
                    this.defaultProperty = beanInfo.getDefaultPropertyIndex();
                    this.propertyStopClass = clazz;
                }
                if (this.explicitEventSetDescriptors == null && beanInfo.getEventSetDescriptors() != null) {
                    this.explicitEventSetDescriptors = beanInfo.getEventSetDescriptors();
                    this.defaultEvent = beanInfo.getDefaultEventIndex();
                    this.eventStopClass = clazz;
                }
                if (this.explicitMethodDescriptors == null && beanInfo.getMethodDescriptors() != null) {
                    this.explicitMethodDescriptors = beanInfo.getMethodDescriptors();
                    this.methodStopClass = clazz;
                }
                if (this.im[0] == null && this.im[1] == null && this.im[2] == null && this.im[3] == null) {
                    this.im[0] = beanInfo.getIcon(0);
                    this.im[1] = beanInfo.getIcon(1);
                    this.im[2] = beanInfo.getIcon(2);
                    this.im[3] = beanInfo.getIcon(3);
                }
            }
            clazz = clazz.getSuperclass();
        }
        if (this.propertyStopClass == null) {
            this.propertyStopClass = clazz2;
        }
        if (this.eventStopClass == null) {
            this.eventStopClass = clazz2;
        }
        if (this.methodStopClass == null) {
            this.methodStopClass = clazz2;
        }
    }

    static void flushCaches() {
        explicitBeanInfos.clear();
        emptyBeanInfos.clear();
    }

    static BeanInfo findExplicitBeanInfo(Class clazz) {
        BeanInfo beanInfo = (BeanInfo)explicitBeanInfos.get(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        if (emptyBeanInfos.indexOf(clazz) != -1) {
            return null;
        }
        beanInfo = ExplicitInfo.reallyFindExplicitBeanInfo(clazz);
        if (beanInfo != null) {
            explicitBeanInfos.put(clazz, beanInfo);
        } else {
            emptyBeanInfos.addElement(clazz);
        }
        return beanInfo;
    }

    static BeanInfo reallyFindExplicitBeanInfo(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        BeanInfo beanInfo = ExplicitInfo.getBeanInfo(classLoader, clazz.getName() + "BeanInfo");
        if (beanInfo == null) {
            String string = ClassHelper.getTruncatedClassName(clazz) + "BeanInfo";
            for (int i = 0; i < Introspector.beanInfoSearchPath.length; ++i) {
                beanInfo = Introspector.beanInfoSearchPath[i].equals("") ? ExplicitInfo.getBeanInfo(classLoader, string) : ExplicitInfo.getBeanInfo(classLoader, Introspector.beanInfoSearchPath[i] + "." + string);
                if (beanInfo == null || beanInfo.getBeanDescriptor() == null || beanInfo.getBeanDescriptor().getBeanClass() != clazz) continue;
                return beanInfo;
            }
        }
        return beanInfo;
    }

    private static BeanInfo getBeanInfo(ClassLoader classLoader, String string) {
        try {
            return (BeanInfo)Class.forName(string, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }
}

