/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private String[] constructorPropertyNames;

    public DefaultPersistenceDelegate() {
    }

    public DefaultPersistenceDelegate(String[] stringArray) {
        this.constructorPropertyNames = stringArray;
    }

    @Override
    protected boolean mutatesTo(Object object, Object object2) {
        try {
            return this.constructorPropertyNames != null && this.constructorPropertyNames.length > 0 && object.getClass().getDeclaredMethod("equals", Object.class) != null ? object.equals(object2) : super.mutatesTo(object, object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.mutatesTo(object, object2);
        }
    }

    @Override
    protected Expression instantiate(Object object, Encoder encoder) {
        Object[] objectArray = null;
        try {
            if (this.constructorPropertyNames != null) {
                objectArray = new Object[this.constructorPropertyNames.length];
                PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
                for (int i = 0; i < this.constructorPropertyNames.length; ++i) {
                    for (int j = 0; j < propertyDescriptorArray.length; ++j) {
                        if (!propertyDescriptorArray[i].getName().equals(this.constructorPropertyNames[i])) continue;
                        Method method = propertyDescriptorArray[i].getReadMethod();
                        objectArray[i] = method.invoke(object, new Object[0]);
                    }
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            encoder.getExceptionListener().exceptionThrown(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            encoder.getExceptionListener().exceptionThrown(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            encoder.getExceptionListener().exceptionThrown(invocationTargetException);
        }
        catch (IntrospectionException introspectionException) {
            encoder.getExceptionListener().exceptionThrown(introspectionException);
        }
        return new Expression(object, object.getClass(), "new", objectArray);
    }

    @Override
    protected void initialize(Class<?> clazz, Object object, Object object2, Encoder encoder) {
        super.initialize(clazz, object, object2, encoder);
        if (clazz != object.getClass()) {
            return;
        }
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Object object3;
                Method method = propertyDescriptorArray[i].getReadMethod();
                Method method2 = propertyDescriptorArray[i].getWriteMethod();
                if (method == null || method2 == null || (object3 = method.invoke(object, new Object[0])) == null) continue;
                encoder.writeStatement(new Statement(object, method2.getName(), new Object[]{object3}));
            }
        }
        catch (IntrospectionException introspectionException) {
            encoder.getExceptionListener().exceptionThrown(introspectionException);
        }
        catch (IllegalAccessException illegalAccessException) {
            encoder.getExceptionListener().exceptionThrown(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            encoder.getExceptionListener().exceptionThrown(invocationTargetException);
        }
    }
}

