/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import gnu.java.lang.CPStringBuilder;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SinglePixelPackedSampleModel unsupported dataType");
            }
        }
        this.scanlineStride = n4;
        this.bitMasks = nArray;
        this.bitOffsets = new int[this.numBands];
        this.sampleSize = new int[this.numBands];
        BitMaskExtent bitMaskExtent = new BitMaskExtent();
        for (int i = 0; i < this.numBands; ++i) {
            long l = (long)nArray[i] & 0xFFFFFFFFL;
            bitMaskExtent.setMask(l);
            this.sampleSize[i] = bitMaskExtent.bitWidth;
            this.bitOffsets[i] = bitMaskExtent.leastSignificantBit;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SinglePixelPackedSampleModel(this.dataType, n, n2, this.bitMasks);
    }

    public DataBuffer createDataBuffer() {
        int n = this.scanlineStride * (this.height - 1) + this.width;
        DataBuffer dataBuffer = null;
        switch (this.getTransferType()) {
            case 0: {
                dataBuffer = new DataBufferByte(n);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n);
            }
        }
        return dataBuffer;
    }

    public int[] getSampleSize() {
        return (int[])this.sampleSize.clone();
    }

    public int getSampleSize(int n) {
        return this.sampleSize[n];
    }

    public int getOffset(int n, int n2) {
        return this.scanlineStride * n2 + n;
    }

    public int[] getBitOffsets() {
        return this.bitOffsets;
    }

    public int[] getBitMasks() {
        return this.bitMasks;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.numBands) {
            throw new RasterFormatException("Too many bands.");
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.bitMasks[nArray[i]];
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        Object[] objectArray = null;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                if (byArray == null) {
                    byArray = new byte[]{(byte)dataBuffer.getElem(n + n2 * this.scanlineStride)};
                }
                objectArray = byArray;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                if (sArray == null) {
                    sArray = new short[]{(short)dataBuffer.getElem(n + n2 * this.scanlineStride)};
                }
                objectArray = sArray;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                if (nArray == null) {
                    nArray = new int[]{dataBuffer.getElem(n + n2 * this.scanlineStride)};
                }
                objectArray = nArray;
            }
        }
        return objectArray;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n;
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n4 = dataBuffer.getElem(n3);
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = (n4 & this.bitMasks[i]) >>> this.bitOffsets[i];
        }
        return nArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.scanlineStride * n2 + n;
        if (nArray == null) {
            nArray = new int[this.numBands * n3 * n4];
        }
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = n5;
            for (n = 0; n < n3; ++n) {
                int n8 = dataBuffer.getElem(n7++);
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[n6++] = (n8 & this.bitMasks[i]) >>> this.bitOffsets[i];
                }
            }
            n5 += this.scanlineStride;
        }
        return nArray;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.scanlineStride * n2 + n;
        int n5 = dataBuffer.getElem(n4);
        return (n5 & this.bitMasks[n3]) >>> this.bitOffsets[n3];
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, byArray[0] & 0xFF);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, sArray[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, nArray[0]);
                break;
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n;
        int n4 = 0;
        for (int i = 0; i < this.numBands; ++i) {
            n4 |= nArray[i] << this.bitOffsets[i] & this.bitMasks[i];
        }
        dataBuffer.setElem(n3, n4);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            int n6 = this.scanlineStride * i + n;
            for (int j = n; j < n + n3; ++j) {
                int n7 = 0;
                for (int k = 0; k < this.numBands; ++k) {
                    n7 |= nArray[n5 + k] << this.bitOffsets[k] & this.bitMasks[k];
                }
                dataBuffer.setElem(0, n6, n7);
                n5 += this.numBands;
                ++n6;
            }
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int n5 = this.scanlineStride * n2 + n;
        int n6 = dataBuffer.getElem(n5);
        int n7 = this.bitMasks[n3];
        n6 &= ~n7;
        dataBuffer.setElem(n5, n6 |= n4 << this.bitOffsets[n3] & n7);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)object;
        if (this.dataType != singlePixelPackedSampleModel.dataType) {
            return false;
        }
        if (this.width != singlePixelPackedSampleModel.width) {
            return false;
        }
        if (this.height != singlePixelPackedSampleModel.height) {
            return false;
        }
        if (this.numBands != singlePixelPackedSampleModel.numBands) {
            return false;
        }
        if (this.scanlineStride != singlePixelPackedSampleModel.scanlineStride) {
            return false;
        }
        if (!Arrays.equals(this.bitMasks, singlePixelPackedSampleModel.bitMasks)) {
            return false;
        }
        return Arrays.equals(this.bitOffsets, singlePixelPackedSampleModel.bitOffsets);
    }

    public int hashCode() {
        int n;
        int n2 = 193;
        n2 = 37 * n2 + this.dataType;
        n2 = 37 * n2 + this.width;
        n2 = 37 * n2 + this.height;
        n2 = 37 * n2 + this.numBands;
        n2 = 37 * n2 + this.scanlineStride;
        for (n = 0; n < this.bitMasks.length; ++n) {
            n2 = 37 * n2 + this.bitMasks[n];
        }
        for (n = 0; n < this.bitOffsets.length; ++n) {
            n2 = 37 * n2 + this.bitOffsets[n];
        }
        return n2;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(this.getClass().getName());
        cPStringBuilder.append("[");
        cPStringBuilder.append("scanlineStride=").append(this.scanlineStride);
        for (int i = 0; i < this.bitMasks.length; ++i) {
            cPStringBuilder.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }
}

