/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicateScaleFilter
extends ImageFilter {
    protected int destHeight;
    protected int destWidth;
    protected int srcHeight;
    protected int srcWidth;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    public ReplicateScaleFilter(int n, int n2) {
        this.destHeight = n2;
        this.destWidth = n;
    }

    @Override
    public void setDimensions(int n, int n2) {
        this.srcWidth = n;
        this.srcHeight = n2;
        if (this.destWidth < 0 && this.destHeight < 0) {
            this.destWidth = n;
            this.destHeight = n2;
        } else if (this.destWidth < 0) {
            this.destWidth = n * this.destHeight / this.srcHeight;
        } else if (this.destHeight < 0) {
            this.destHeight = n2 * this.destWidth / this.srcWidth;
        }
        if (this.consumer != null) {
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }
    }

    @Override
    public void setProperties(Hashtable<?, ?> hashtable) {
        Hashtable<?, ?> hashtable2 = hashtable;
        hashtable2.put("filters", "ReplicateScaleFilter");
        if (this.consumer != null) {
            this.consumer.setProperties(hashtable2);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        byte[] byArray2;
        if (this.srcrows == null || this.srccols == null) {
            this.setupSources();
        }
        int n8 = (2 * n * this.destWidth + this.srcWidth - 1) / (2 * this.destWidth);
        int n9 = (2 * n2 * this.destHeight + this.srcHeight - 1) / (2 * this.destHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof byte[]) {
            byArray2 = (byte[])this.outpixbuf;
        } else {
            byArray2 = new byte[this.destWidth];
            this.outpixbuf = byArray2;
        }
        int n10 = n9;
        while ((n7 = this.srcrows[n10]) < n2 + n4) {
            int n11;
            int n12 = n5 + n6 * (n7 - n2);
            int n13 = n8;
            while ((n11 = this.srccols[n13]) < n + n3) {
                byArray2[n13] = byArray[n12 + n11 - n];
                ++n13;
            }
            if (n13 > n8) {
                this.consumer.setPixels(n8, n10, n13 - n8, 1, colorModel, byArray2, n8, this.destWidth);
            }
            ++n10;
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7;
        int[] nArray2;
        if (this.srcrows == null || this.srccols == null) {
            this.setupSources();
        }
        int n8 = (2 * n * this.destWidth + this.srcWidth - 1) / (2 * this.destWidth);
        int n9 = (2 * n2 * this.destHeight + this.srcHeight - 1) / (2 * this.destHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof int[]) {
            nArray2 = (int[])this.outpixbuf;
        } else {
            nArray2 = new int[this.destWidth];
            this.outpixbuf = nArray2;
        }
        int n10 = n9;
        while ((n7 = this.srcrows[n10]) < n2 + n4) {
            int n11;
            int n12 = n5 + n6 * (n7 - n2);
            int n13 = n8;
            while ((n11 = this.srccols[n13]) < n + n3) {
                nArray2[n13] = nArray[n12 + n11 - n];
                ++n13;
            }
            if (n13 > n8) {
                this.consumer.setPixels(n8, n10, n13 - n8, 1, colorModel, nArray2, n8, this.destWidth);
            }
            ++n10;
        }
    }

    private void setupSources() {
        int n;
        this.srcrows = new int[this.destHeight + 1];
        for (n = 0; n <= this.destHeight; ++n) {
            this.srcrows[n] = (2 * n * this.srcHeight + this.srcHeight) / (2 * this.destHeight);
        }
        this.srccols = new int[this.destWidth + 1];
        for (n = 0; n <= this.destWidth; ++n) {
            this.srccols[n] = (2 * n * this.srcWidth + this.srcWidth) / (2 * this.destWidth);
        }
    }
}

